/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class SmokingRecipeBuilder {
    private Ingredient input;
    protected String group;
    private ItemStack output = ItemStack.f_41583_;
    private float experience;
    private int cookingTime;
    protected ResourceLocation id;

    public SmokingRecipeBuilder(@Nullable ResourceLocation id) {
        this.id = id;
    }

    public SmokingRecipeBuilder input(TagKey<Item> itemStack) {
        return this.input(Ingredient.m_204132_(itemStack));
    }

    public SmokingRecipeBuilder input(ItemStack itemStack) {
        this.input = itemStack.m_41782_() || itemStack.m_41773_() > 0 ? NBTIngredient.createNBTIngredient(itemStack) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack});
        return this;
    }

    public SmokingRecipeBuilder input(ItemLike itemLike) {
        return this.input(Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public SmokingRecipeBuilder input(Ingredient ingredient) {
        this.input = ingredient;
        return this;
    }

    public SmokingRecipeBuilder output(ItemStack itemStack) {
        this.output = itemStack.m_41777_();
        return this;
    }

    public SmokingRecipeBuilder output(ItemStack itemStack, int count) {
        this.output = itemStack.m_41777_();
        this.output.m_41764_(count);
        return this;
    }

    public SmokingRecipeBuilder output(ItemStack itemStack, int count, CompoundTag nbt) {
        this.output = itemStack.m_41777_();
        this.output.m_41764_(count);
        this.output.m_41751_(nbt);
        return this;
    }

    protected ResourceLocation defaultId() {
        return BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_());
    }

    public void toJson(JsonObject json) {
        if (this.group != null) {
            json.addProperty("group", this.group);
        }
        if (!this.input.m_43947_()) {
            json.add("ingredient", this.input.m_43942_());
        }
        if (this.output.m_41619_()) {
            LDLib.LOGGER.error("shapeless recipe {} output is empty", (Object)this.id);
            throw new IllegalArgumentException(this.id + ": output items is empty");
        }
        JsonObject result = new JsonObject();
        result.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_()).toString());
        if (this.output.m_41613_() > 1) {
            result.addProperty("count", (Number)this.output.m_41613_());
        }
        if (this.output.m_41782_() && this.output.m_41783_() != null) {
            result.add("nbt", NBTToJsonConverter.getObject((Tag)this.output.m_41783_()));
        }
        json.add("result", (JsonElement)result);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        json.addProperty("cookingtime", (Number)this.cookingTime);
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(){

            public void m_7917_(JsonObject pJson) {
                SmokingRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation m_6445_() {
                ResourceLocation ID = SmokingRecipeBuilder.this.id == null ? SmokingRecipeBuilder.this.defaultId() : SmokingRecipeBuilder.this.id;
                return new ResourceLocation(ID.m_135827_(), "smoking/" + ID.m_135815_());
            }

            public RecipeSerializer<?> m_6637_() {
                return RecipeSerializer.f_44093_;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        });
    }

    public SmokingRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public SmokingRecipeBuilder experience(float experience) {
        this.experience = experience;
        return this;
    }

    public SmokingRecipeBuilder cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    public SmokingRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }
}

