/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.misc;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidContainerIngredient;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.data.recipe.VanillaRecipeHelper;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;

public class VanillaStandardRecipes {
    public static void init(Consumer<FinishedRecipe> provider) {
        VanillaStandardRecipes.compressingRecipes(provider);
        VanillaStandardRecipes.glassRecipes(provider);
        VanillaStandardRecipes.smashingRecipes(provider);
        VanillaStandardRecipes.woodRecipes(provider);
        VanillaStandardRecipes.cuttingRecipes(provider);
        VanillaStandardRecipes.dyingCleaningRecipes(provider);
        VanillaStandardRecipes.redstoneRecipes(provider);
        VanillaStandardRecipes.metalRecipes(provider);
        VanillaStandardRecipes.miscRecipes(provider);
        VanillaStandardRecipes.mixingRecipes(provider);
        VanillaStandardRecipes.dyeRecipes(provider);
    }

    private static void compressingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("stone_from_dust", new Object[0]).duration(300).EUt(2L).inputItems(TagPrefix.plate, GTMaterials.Stone, 9).outputItems(new ItemStack((ItemLike)Blocks.f_50069_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("sandstone", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.f_49992_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50062_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("red_sandstone", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.f_49993_)).outputItems(new ItemStack((ItemLike)Blocks.f_50394_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("bricks", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42460_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50076_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("nether_bricks", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42691_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50197_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("ice_from_snow", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Blocks.f_50125_)).outputItems(new ItemStack((ItemLike)Blocks.f_50126_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("clay", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42461_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50129_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("snowballs_to_snow", new Object[0]).duration(200).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42452_, 4)).outputItems(new ItemStack((ItemLike)Items.f_41981_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("glowstone", new Object[0]).duration(300).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42525_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50141_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("packed_ice", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50126_, 9)).outputItems(new ItemStack((ItemLike)Blocks.f_50354_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("blue_ice", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50354_, 9)).outputItems(new ItemStack((ItemLike)Blocks.f_50568_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("ice_from_dust", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Ice).outputItems(new ItemStack((ItemLike)Blocks.f_50126_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("dripstone_block_from_pointed_dripstone", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_151087_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_152537_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("pointed_dripstone_from_dripstone_block", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_152537_)).outputItems(new ItemStack((ItemLike)Items.f_151087_, 4)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("hay_block", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42405_, 9)).circuitMeta(8).outputItems(new ItemStack((ItemLike)Blocks.f_50335_)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("wheat", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50335_)).outputItems(new ItemStack((ItemLike)Items.f_42405_, 9)).circuitMeta(9).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("wheat_from_hay_block", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50335_)).outputItems(new ItemStack((ItemLike)Items.f_42405_, 9)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("melon", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42575_, 9)).circuitMeta(9).outputItems(new ItemStack((ItemLike)Blocks.f_50186_)).duration(200).EUt(2L).save(provider);
    }

    private static void glassRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "glass_dust_hammer", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Glass), "hG", Character.valueOf('G'), new ItemStack((ItemLike)Blocks.f_50058_));
        VanillaRecipeHelper.addShapedRecipe(provider, "quartz_sand", ChemicalHelper.get(TagPrefix.dust, GTMaterials.QuartzSand), "S", "m", Character.valueOf('S'), new ItemStack((ItemLike)Blocks.f_49992_));
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("quartz_sand_from_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_49992_)).outputItems(TagPrefix.dust, GTMaterials.QuartzSand).duration(30).EUt(2L).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, "glass_dust_flint", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Glass), new UnificationEntry(TagPrefix.dust, GTMaterials.QuartzSand), new UnificationEntry(TagPrefix.dustTiny, GTMaterials.Flint));
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("glass_from_quartzite", new Object[0]).duration(160).EUt(GTValues.VA[0]).inputItems(TagPrefix.dustSmall, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.Quartzite, 4).outputItems(TagPrefix.dust, GTMaterials.Glass, 5).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("glass_from_quartz_sand", new Object[0]).duration(200).EUt(GTValues.VA[0]).inputItems(TagPrefix.dustSmall, GTMaterials.Flint).inputItems(TagPrefix.dust, GTMaterials.QuartzSand, 4).outputItems(TagPrefix.dust, GTMaterials.Glass, 4).save(provider);
        GTRecipeTypes.ARC_FURNACE_RECIPES.recipeBuilder("glass_from_sand", new Object[0]).duration(20).EUt(GTValues.VA[1]).inputItems(new ItemStack((ItemLike)Blocks.f_49992_)).outputItems(new ItemStack((ItemLike)Blocks.f_50058_, 2)).save(provider);
        GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("form_glass", new Object[0]).duration(80).EUt(GTValues.VA[1]).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.f_50058_)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("glass_bottle", new Object[0]).duration(64).EUt(4L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BOTTLE).outputItems(new ItemStack((ItemLike)Items.f_42590_)).save(provider);
        GTRecipeTypes.EXTRUDER_RECIPES.recipeBuilder("glass_bottle", new Object[0]).duration(32).EUt(16L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_EXTRUDER_BOTTLE).outputItems(new ItemStack((ItemLike)Items.f_42590_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("glass_bottle", new Object[0]).duration(12).EUt(4L).inputFluids(GTMaterials.Glass.getFluid(144)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BOTTLE).outputItems(new ItemStack((ItemLike)Items.f_42590_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_glass_block", new Object[0]).duration(12).EUt(4L).inputFluids(GTMaterials.Glass.getFluid(144)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.f_50058_)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("glass", new Object[0]).duration(120).EUt(16L).inputItems(TagPrefix.dust, GTMaterials.Glass).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).outputItems(new ItemStack((ItemLike)Blocks.f_50058_, 1)).save(provider);
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_glass_block_to_plate", new Object[0]).duration(50).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50058_, 3)).outputItems(new ItemStack((ItemLike)Blocks.f_50185_, 8)).save(provider);
    }

    private static void smashingRecipes(Consumer<FinishedRecipe> provider) {
        VanillaRecipeHelper.addShapedRecipe(provider, "cobblestone_hammer", new ItemStack((ItemLike)Blocks.f_50652_), "h", "C", Character.valueOf('C'), new ItemStack((ItemLike)Blocks.f_50069_));
        VanillaRecipeHelper.addShapedRecipe(provider, "cobbled_deepslate_hammer", new ItemStack((ItemLike)Blocks.f_152551_), "h", "C", Character.valueOf('C'), new ItemStack((ItemLike)Blocks.f_152550_));
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("stone_to_cobblestone", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50069_)).outputItems(new ItemStack((ItemLike)Blocks.f_50652_)).EUt(16L).duration(10).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("deepslate_to_cobbled_deepslate", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_152550_)).outputItems(new ItemStack((ItemLike)Blocks.f_152551_)).EUt(16L).duration(10).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("cobblestone_to_gravel", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13166_).outputItems(new ItemStack((ItemLike)Blocks.f_49994_)).EUt(16L).duration(10).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("gravel_to_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_49994_)).outputItems(new ItemStack((ItemLike)Blocks.f_49992_)).EUt(16L).duration(10).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("gravel_to_flint", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_49994_, 1)).outputItems(TagPrefix.dust, GTMaterials.Stone).chancedOutput(new ItemStack((ItemLike)Items.f_42484_), 1000, 1000).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("sandstone_to_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50062_)).outputItems(new ItemStack((ItemLike)Blocks.f_49992_)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("smooth_sandstone_to_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50471_)).outputItems(new ItemStack((ItemLike)Blocks.f_49992_)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("chiseled_sandstone_to_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50063_)).outputItems(new ItemStack((ItemLike)Blocks.f_49992_)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("red_sandstone_to_red_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50394_)).outputItems(new ItemStack((ItemLike)Blocks.f_49993_)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("smooth_red_sandstone_to_red_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50473_)).outputItems(new ItemStack((ItemLike)Blocks.f_49993_)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("chiseled_red_sandstone_to_red_sand", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50395_)).outputItems(new ItemStack((ItemLike)Blocks.f_49993_)).EUt(2L).duration(400).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("cracked_stone_bricks", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50222_)).outputItems(new ItemStack((ItemLike)Blocks.f_50224_)).EUt(2L).duration(400).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, "clay_block_to_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Clay), Character.valueOf('m'), Blocks.f_50129_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "clay_ball_to_dust", ChemicalHelper.get(TagPrefix.dustSmall, GTMaterials.Clay), Character.valueOf('m'), Items.f_42461_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "brick_block_to_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Brick), Character.valueOf('m'), Blocks.f_50076_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "brick_to_dust", ChemicalHelper.get(TagPrefix.dustSmall, GTMaterials.Brick), Character.valueOf('m'), Items.f_42460_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "wheat_to_dust", ChemicalHelper.get(TagPrefix.dust, GTMaterials.Wheat), Character.valueOf('m'), Items.f_42405_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "gravel_to_flint", new ItemStack((ItemLike)Items.f_42484_), Character.valueOf('m'), Blocks.f_49994_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "bone_to_bone_meal", new ItemStack((ItemLike)Items.f_42499_, 4), Character.valueOf('m'), Items.f_42500_);
        VanillaRecipeHelper.addShapelessRecipe(provider, "blaze_rod_to_powder", new ItemStack((ItemLike)Items.f_42593_, 3), Character.valueOf('m'), Items.f_42585_);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_cocoa", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42533_)).outputItems(TagPrefix.dust, GTMaterials.Cocoa).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_sugar_cane", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_41909_)).outputItems(new ItemStack((ItemLike)Items.f_42501_)).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_melon_block", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50186_)).outputItems(new ItemStack((ItemLike)Items.f_42575_, 8)).chancedOutput(new ItemStack((ItemLike)Items.f_42578_), 8000, 500).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_pumpkin", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50133_)).outputItems(new ItemStack((ItemLike)Items.f_42577_, 4)).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_melon_slice", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42575_)).outputItems(new ItemStack((ItemLike)Items.f_42578_)).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_wool", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13167_).outputItems(new ItemStack((ItemLike)Items.f_42401_)).chancedOutput(new ItemStack((ItemLike)Items.f_42401_), 9000, 0).chancedOutput(new ItemStack((ItemLike)Items.f_42401_), 5000, 0).chancedOutput(new ItemStack((ItemLike)Items.f_42401_), 2000, 0).duration(200).EUt(2L).save(provider);
    }

    private static void woodRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder("macerate_logs", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13182_).outputItems(TagPrefix.dust, GTMaterials.Wood, 6).chancedOutput(TagPrefix.dust, GTMaterials.Wood, 8000, 680).duration(150).EUt(2L).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_planks", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_).outputItems(new ItemStack((ItemLike)Items.f_42398_, 2)).duration(10).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_logs", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13182_).outputItems(TagPrefix.rodLong, GTMaterials.Wood, 4).outputItems(TagPrefix.dust, GTMaterials.Wood, 2).duration(160).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_saplings", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13180_).outputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(TagPrefix.dustTiny, GTMaterials.Wood).duration(16).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.LATHE_RECIPES.recipeBuilder("lathe_wood_slabs", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13175_).outputItems(new ItemStack((ItemLike)Items.f_42399_)).outputItems(TagPrefix.dustSmall, GTMaterials.Wood).duration(50).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bookshelf", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 6).inputItems(new ItemStack((ItemLike)Items.f_42517_, 3)).outputItems(new ItemStack((ItemLike)Blocks.f_50078_)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chest", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 8).outputItems(new ItemStack((ItemLike)Blocks.f_50087_)).duration(100).EUt(4L).circuitMeta(8).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coal", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13160_).inputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 4)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coal_dust", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Coal).inputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 4)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_charcoal_dust", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Charcoal).inputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 4)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coke_gem", new Object[0]).inputItems(TagPrefix.gem, GTMaterials.Coke).inputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 8)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_coke_dust", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Coke).inputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 8)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_torch", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50081_)).inputItems((TagKey<Item>)ItemTags.f_13154_).outputItems(new ItemStack((ItemLike)Blocks.f_50139_)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern_from_lantern", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50681_)).inputItems((TagKey<Item>)ItemTags.f_13154_).outputItems(new ItemStack((ItemLike)Blocks.f_50682_)).duration(100).EUt(1L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "sticky_resin_torch", new ItemStack((ItemLike)Blocks.f_50081_, 3), "X", "Y", Character.valueOf('X'), GTItems.STICKY_RESIN, Character.valueOf('Y'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_sulfur", new ItemStack((ItemLike)Blocks.f_50081_, 2), "C", "S", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Sulfur), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_phosphorus", new ItemStack((ItemLike)Blocks.f_50081_, 6), "C", "S", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Phosphorus), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_coal_dust", new ItemStack((ItemLike)Blocks.f_50081_, 4), "C", "S", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Coal), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_charcoal_dust", new ItemStack((ItemLike)Blocks.f_50081_, 4), "C", "S", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Charcoal), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_coke", new ItemStack((ItemLike)Blocks.f_50081_, 8), "C", "S", Character.valueOf('C'), new UnificationEntry(TagPrefix.gem, GTMaterials.Coke), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_coke_dust", new ItemStack((ItemLike)Blocks.f_50081_, 8), "C", "S", Character.valueOf('C'), new UnificationEntry(TagPrefix.dust, GTMaterials.Coke), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_));
        VanillaRecipeHelper.addShapedRecipe(provider, "torch_creosote", new ItemStack((ItemLike)Blocks.f_50081_, 16), new Object[]{"WB", "S ", Character.valueOf('W'), ItemTags.f_13167_, Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42398_), Character.valueOf('B'), new FluidContainerIngredient(GTMaterials.Creosote.getFluidTag(), 1000)});
        VanillaRecipeHelper.addShapedRecipe(provider, "soul_torch", new ItemStack((ItemLike)Blocks.f_50139_, 1), "WB", Character.valueOf('W'), ItemTags.f_13154_, Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50081_));
        if (!ConfigHolder.INSTANCE.recipes.hardMiscRecipes) {
            VanillaRecipeHelper.addShapedRecipe(provider, "soul_lantern_from_lantern", new ItemStack((ItemLike)Blocks.f_50682_, 1), "WB", Character.valueOf('W'), ItemTags.f_13154_, Character.valueOf('B'), new ItemStack((ItemLike)Blocks.f_50681_));
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("soul_lantern_from_lantern", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50681_)).inputItems((TagKey<Item>)ItemTags.f_13154_).outputItems(new ItemStack((ItemLike)Blocks.f_50682_)).duration(100).EUt(1L).save(provider);
        }
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("redstone_torch", new Object[0]).EUt(4L).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputItems(new ItemStack((ItemLike)Items.f_42398_)).outputItems(new ItemStack((ItemLike)Blocks.f_50174_, 1)).circuitMeta(3).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_sulfur", new Object[0]).EUt(4L).inputItems(new ItemStack((ItemLike)Items.f_42398_)).inputItems(TagPrefix.dust, GTMaterials.Sulfur).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 2)).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("torch_phosphorus", new Object[0]).EUt(4L).inputItems(new ItemStack((ItemLike)Items.f_42398_)).inputItems(TagPrefix.dust, GTMaterials.Phosphorus).outputItems(new ItemStack((ItemLike)Blocks.f_50081_, 6)).duration(100).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ladder", new Object[0]).EUt(4L).duration(40).circuitMeta(7).inputItems(new ItemStack((ItemLike)Items.f_42398_, 7)).outputItems(new ItemStack((ItemLike)Blocks.f_50155_, 2)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("barrel", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13168_, 7).outputItems(new ItemStack((ItemLike)Blocks.f_50618_)).circuitMeta(24).duration(100).EUt(4L).save(provider);
    }

    private static void cuttingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("snow_layer", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50127_)).outputItems(new ItemStack((ItemLike)Blocks.f_50125_, 12)).duration(25).EUt(GTValues.VA[0]).save(provider);
    }

    private static void dyingCleaningRecipes(Consumer<FinishedRecipe> provider) {
        for (DyeColor color : DyeColor.values()) {
            String dyeName = color.m_41065_();
            GTRecipeTypes.MIXER_RECIPES.recipeBuilder(dyeName + "_concrete_powder", new Object[0]).duration(200).EUt(GTValues.VA[0]).inputItems((TagKey<Item>)Tags.Items.SAND, 4).inputItems((TagKey<Item>)Tags.Items.GRAVEL, 4).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_concrete_powder")), 8)).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder(dyeName + "_concrete", new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_concrete_powder")))).inputFluids(GTMaterials.Water.getFluid(1000)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_concrete")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            if (color != DyeColor.WHITE) {
                GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_concrete_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(CustomTags.CONCRETE_ITEM).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_concrete")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            }
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_terracotta_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50352_)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_terracotta")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_glass_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50058_)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_stained_glass")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_glass_pane_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50185_)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_stained_glass_pane")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + dyeName + "_glass_to_pane", new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_stained_glass"))).outputItems((Item)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_stained_glass_pane"))).save(provider);
            GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_candle_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Items.f_151065_)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(18)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_candle")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            if (color != DyeColor.WHITE) {
                GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_wool_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50041_)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_wool")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
                GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dye_bed_to_" + dyeName, new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50066_)).inputFluids(GTMaterials.CHEMICAL_DYES[color.ordinal()].getFluid(144)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_bed")))).category(GTRecipeCategories.CHEM_DYES).save(provider);
            }
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("cut_" + dyeName + "_wool_to_carpet", new Object[0]).duration(20).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_wool")), 1)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_carpet")), 2)).save(provider);
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder(dyeName + "_banner", new Object[0]).duration(20).EUt(GTValues.VA[0]).circuitMeta(6).inputItems(new ItemStack((ItemLike)Items.f_42398_)).inputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_wool")), 6)).outputItems(new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(dyeName + "_banner")))).save(provider);
        }
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_wool", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13167_).inputFluids(GTMaterials.Chlorine.getFluid(50)).outputItems(new ItemStack((ItemLike)Blocks.f_50041_)).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_carpet", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_215867_).inputFluids(GTMaterials.Chlorine.getFluid(25)).outputItems(new ItemStack((ItemLike)Blocks.f_50336_)).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_terracotta", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_198161_).inputFluids(GTMaterials.Chlorine.getFluid(50)).outputItems(Items.f_42199_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_stained_glass", new Object[0]).inputItems((TagKey<Item>)Tags.Items.STAINED_GLASS).inputFluids(GTMaterials.Chlorine.getFluid(50)).outputItems(Items.f_41904_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_stained_glass_pane", new Object[0]).inputItems((TagKey<Item>)Tags.Items.STAINED_GLASS_PANES).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.f_42027_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_concrete", new Object[0]).inputItems(CustomTags.CONCRETE_ITEM).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.f_42246_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("sticky_piston_to_piston", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50032_)).inputFluids(GTMaterials.Chlorine.getFluid(10)).outputItems(new ItemStack((ItemLike)Blocks.f_50039_)).duration(30).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_candle", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_144319_).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.f_151065_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("decolor_bed", new Object[0]).inputItems((TagKey<Item>)ItemTags.f_13146_).inputFluids(GTMaterials.Chlorine.getFluid(20)).outputItems(Items.f_42503_).category(GTRecipeCategories.CHEM_DYES).duration(400).EUt(2L).save(provider);
    }

    private static void redstoneRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_resin", new Object[0]).inputItems((Supplier<? extends Item>)GTItems.STICKY_RESIN).inputItems(new ItemStack((ItemLike)Blocks.f_50039_)).outputItems(new ItemStack((ItemLike)Blocks.f_50032_)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_slime", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42518_)).inputItems(new ItemStack((ItemLike)Blocks.f_50039_)).outputItems(new ItemStack((ItemLike)Blocks.f_50032_)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sticky_piston_glue", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50039_)).inputFluids(GTMaterials.Glue.getFluid(100)).outputItems(new ItemStack((ItemLike)Blocks.f_50032_)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tripwire_hook_iron", new Object[0]).inputItems(Items.f_42398_, 2).inputItems(TagPrefix.ring, GTMaterials.Iron, 2).outputItems(new ItemStack((ItemLike)Blocks.f_50266_, 1)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tripwire_hook_wrought_iron", new Object[0]).inputItems(Items.f_42398_, 2).inputItems(TagPrefix.ring, GTMaterials.WroughtIron, 2).outputItems(new ItemStack((ItemLike)Blocks.f_50266_, 1)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("redstone_lamp", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Redstone, 4).inputItems(TagPrefix.dust, GTMaterials.Glowstone, 4).outputItems(new ItemStack((ItemLike)Blocks.f_50261_)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("repeater", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50174_, 2)).inputItems(TagPrefix.dust, GTMaterials.Redstone).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.f_42350_)).duration(100).EUt(10L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_nether_quartz", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50174_, 3)).inputItems(TagPrefix.gem, GTMaterials.NetherQuartz).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.f_42351_)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_certus_quartz", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50174_, 3)).inputItems(TagPrefix.gem, GTMaterials.CertusQuartz).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.f_42351_)).duration(100).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("comparator_quartzite", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50174_, 3)).inputItems(TagPrefix.gem, GTMaterials.Quartzite).inputFluids(GTMaterials.Concrete.getFluid(144)).outputItems(new ItemStack((ItemLike)Items.f_42351_)).duration(100).EUt(1L).save(provider);
        if (!ConfigHolder.INSTANCE.recipes.hardRedstoneRecipes) {
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("stone_pressure_plate", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50404_)).outputItems(new ItemStack((ItemLike)Blocks.f_50165_, 8)).duration(250).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("polished_blackstone_pressure_plate", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50708_)).outputItems(new ItemStack((ItemLike)Blocks.f_50709_, 8)).duration(250).EUt(GTValues.VA[0]).save(provider);
            GTRecipeTypes.CUTTER_RECIPES.recipeBuilder("polished_blackstone_pressure_plate", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron).outputItems(new ItemStack((ItemLike)Blocks.f_50709_, 8)).circuitMeta(10).duration(250).EUt(GTValues.VA[0]).save(provider);
        }
    }

    private static void metalRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.BENDER_RECIPES.recipeBuilder("bucket", new Object[0]).circuitMeta(12).inputItems(TagPrefix.plate, GTMaterials.Iron, 3).outputItems(new ItemStack((ItemLike)Items.f_42446_)).duration(100).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "leather_horse_armor", new ItemStack((ItemLike)Items.f_42654_), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42407_), Character.valueOf('P'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42408_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42462_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "iron_horse_armor", new ItemStack((ItemLike)Items.f_42651_), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42468_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Iron), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42469_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42470_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Iron));
        VanillaRecipeHelper.addShapedRecipe(provider, "golden_horse_armor", new ItemStack((ItemLike)Items.f_42652_), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42476_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Gold), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42477_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42478_), Character.valueOf('S'), new UnificationEntry(TagPrefix.screw, GTMaterials.Gold));
        VanillaRecipeHelper.addShapedRecipe(provider, "diamond_horse_armor", new ItemStack((ItemLike)Items.f_42653_), "hdH", "PCP", "LSL", Character.valueOf('H'), new ItemStack((ItemLike)Items.f_42472_), Character.valueOf('P'), new UnificationEntry(TagPrefix.plate, GTMaterials.Diamond), Character.valueOf('C'), new ItemStack((ItemLike)Items.f_42473_), Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42474_), Character.valueOf('S'), new UnificationEntry(TagPrefix.bolt, GTMaterials.Diamond));
        VanillaRecipeHelper.addShapedRecipe(provider, "chainmail_helmet", new ItemStack((ItemLike)Items.f_42464_), "PPP", "PhP", Character.valueOf('P'), Items.f_42026_);
        VanillaRecipeHelper.addShapedRecipe(provider, "chainmail_chestplate", new ItemStack((ItemLike)Items.f_42465_), "PhP", "PPP", "PPP", Character.valueOf('P'), Items.f_42026_);
        VanillaRecipeHelper.addShapedRecipe(provider, "chainmail_leggings", new ItemStack((ItemLike)Items.f_42466_), "PPP", "PhP", "P P", Character.valueOf('P'), Items.f_42026_);
        VanillaRecipeHelper.addShapedRecipe(provider, "chainmail_boots", new ItemStack((ItemLike)Items.f_42467_), "P P", "PhP", Character.valueOf('P'), Items.f_42026_);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("cauldron", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 7).outputItems(new ItemStack((ItemLike)Items.f_42544_, 1)).circuitMeta(7).duration(700).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_nars", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Iron, 3).outputItems(new ItemStack((ItemLike)Blocks.f_50183_, 4)).circuitMeta(3).duration(300).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_trapdoor", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 4).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.f_50376_)).duration(100).EUt(16L).save(provider);
        if (!ConfigHolder.INSTANCE.recipes.hardAdvancedIronRecipes) {
            GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("iron_door", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 6).circuitMeta(6).outputItems(new ItemStack((ItemLike)Items.f_42341_, 3)).duration(100).EUt(16L).save(provider);
        }
    }

    private static void miscRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("book_from_leather", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42516_, 3)).inputItems(new ItemStack((ItemLike)Items.f_42454_)).inputFluids(GTMaterials.Glue.getFluid(20)).outputItems(new ItemStack((ItemLike)Items.f_42517_)).duration(32).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("book_from_pvc", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42516_, 3)).inputItems(TagPrefix.foil, GTMaterials.PolyvinylChloride).inputFluids(GTMaterials.Glue.getFluid(20)).outputItems(new ItemStack((ItemLike)Items.f_42517_)).duration(20).EUt(16L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("map", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42516_, 8)).inputItems(new ItemStack((ItemLike)Items.f_42522_)).outputItems(new ItemStack((ItemLike)Items.f_42676_)).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("form_nether_brick", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Netherrack).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(new ItemStack((ItemLike)Items.f_42691_)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("form_brick", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42461_)).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_INGOT).outputItems(new ItemStack((ItemLike)Items.f_42460_)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("lead", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42401_)).inputItems(new ItemStack((ItemLike)Items.f_42518_)).outputItems(new ItemStack((ItemLike)Items.f_42655_, 2)).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("name_tag", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42454_)).inputItems(new ItemStack((ItemLike)Items.f_42655_)).inputFluids(GTMaterials.Glue.getFluid(100)).outputItems(new ItemStack((ItemLike)Items.f_42656_)).duration(100).EUt(GTValues.VA[0]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("bow", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42401_, 3)).inputItems(Items.f_42398_, 3).outputItems(new ItemStack((ItemLike)Items.f_42411_, 1)).circuitMeta(10).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("crossbow", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42401_, 2)).inputItems(Items.f_42398_, 3).inputItems(Items.f_42109_).outputItems(new ItemStack((ItemLike)Items.f_42717_, 1)).circuitMeta(11).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snowball", new Object[0]).duration(128).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BALL).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.f_42452_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snowball_distilled", new Object[0]).duration(128).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BALL).inputFluids(GTMaterials.DistilledWater.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.f_42452_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snow_block", new Object[0]).duration(512).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.Water.getFluid(1000)).outputItems(new ItemStack((ItemLike)Blocks.f_50127_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("snow_block_distilled", new Object[0]).duration(512).EUt(4L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.DistilledWater.getFluid(1000)).outputItems(new ItemStack((ItemLike)Blocks.f_50127_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("obsidian", new Object[0]).duration(1024).EUt(16L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_BLOCK).inputFluids(GTMaterials.Lava.getFluid(1000)).outputItems(new ItemStack((ItemLike)Blocks.f_50080_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("solidify_anvil", new Object[0]).duration(1680).EUt(16L).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_ANVIL).inputFluids(GTMaterials.Iron.getFluid(4464)).outputItems(new ItemStack((ItemLike)Blocks.f_50322_)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("anvil", new Object[0]).inputItems(TagPrefix.ingot, GTMaterials.Iron, 31).notConsumable((Supplier<? extends Item>)GTItems.SHAPE_MOLD_ANVIL).outputItems(new ItemStack((ItemLike)Blocks.f_50322_)).duration(1680).EUt(16L).save(provider);
        VanillaRecipeHelper.addSmeltingRecipe(provider, "sticky_resin_from_slime", new ItemStack((ItemLike)Items.f_42518_), GTItems.STICKY_RESIN.asStack(), 0.3f);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("wool_from_string", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42401_, 4)).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.f_50041_)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mossy_cobblestone_from_vine", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50652_)).inputItems(new ItemStack((ItemLike)Blocks.f_50191_)).outputItems(new ItemStack((ItemLike)Blocks.f_50079_)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mossy_cobblestone_from_moss_block", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50652_)).inputItems(new ItemStack((ItemLike)Blocks.f_152544_)).outputItems(new ItemStack((ItemLike)Blocks.f_50079_)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mossy_stone_bricks_from_vine", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50222_)).inputItems(new ItemStack((ItemLike)Blocks.f_50191_)).outputItems(new ItemStack((ItemLike)Blocks.f_50223_)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("mossy_stone_bricks_from_moss_block", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50222_)).inputItems(new ItemStack((ItemLike)Blocks.f_152544_)).outputItems(new ItemStack((ItemLike)Blocks.f_50223_)).duration(40).EUt(1L).save(provider);
        GTRecipeTypes.CANNER_RECIPES.recipeBuilder("jack_o_lantern", new Object[0]).EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Blocks.f_50133_)).inputItems(new ItemStack((ItemLike)Blocks.f_50081_)).outputItems(new ItemStack((ItemLike)Blocks.f_50144_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("sea_lantern", new Object[0]).EUt(4L).duration(40).inputItems(new ItemStack((ItemLike)Items.f_42696_, 5)).inputItems(new ItemStack((ItemLike)Items.f_42695_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50386_)).save(provider);
        GTRecipeTypes.ALLOY_SMELTER_RECIPES.recipeBuilder("red_nether_bricks", new Object[0]).EUt(4L).duration(40).inputItems(new ItemStack((ItemLike)Items.f_42691_, 2)).inputItems(new ItemStack((ItemLike)Items.f_42588_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50452_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("nether_brick_fence", new Object[0]).duration(100).EUt(4L).circuitMeta(3).inputItems(new ItemStack((ItemLike)Blocks.f_50197_)).outputItems(new ItemStack((ItemLike)Blocks.f_50198_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("end_rod", new Object[0]).duration(100).EUt(4L).inputItems(new ItemStack((ItemLike)Items.f_42731_)).inputItems(new ItemStack((ItemLike)Items.f_42585_)).outputItems(new ItemStack((ItemLike)Blocks.f_50489_, 4)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("purple_shulker_box", new Object[0]).duration(100).EUt(GTValues.VA[0]).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).inputItems(new ItemStack((ItemLike)Items.f_42748_, 2)).outputItems(new ItemStack((ItemLike)Blocks.f_50520_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("painting", new Object[0]).duration(100).EUt(4L).circuitMeta(1).inputItems((TagKey<Item>)ItemTags.f_13167_).inputItems(new ItemStack((ItemLike)Items.f_42398_, 8)).outputItems(new ItemStack((ItemLike)Items.f_42487_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("item_frame", new Object[0]).duration(100).EUt(4L).inputItems(new ItemStack((ItemLike)Items.f_42454_)).inputItems(new ItemStack((ItemLike)Items.f_42398_, 8)).outputItems(new ItemStack((ItemLike)Items.f_42617_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("flower_pot", new Object[0]).duration(10).EUt(2L).inputItems(new ItemStack((ItemLike)Items.f_42460_, 3)).outputItems(new ItemStack((ItemLike)Items.f_42618_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("end_crystal", new Object[0]).duration(30).EUt(16L).inputItems(new ItemStack((ItemLike)Items.f_42586_)).inputItems(new ItemStack((ItemLike)Items.f_42545_)).outputItems(new ItemStack((ItemLike)Items.f_42729_)).inputFluids(GTMaterials.Glass.getFluid(1008)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("rail", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(new ItemStack((ItemLike)Items.f_42398_)).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.f_50156_, 32)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("powered_rail", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Gold, 12).inputItems(new ItemStack((ItemLike)Items.f_42398_)).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(1).outputItems(new ItemStack((ItemLike)Blocks.f_50030_, 12)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("detector_rail", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(new ItemStack((ItemLike)Items.f_42398_)).inputItems(TagPrefix.dust, GTMaterials.Redstone).circuitMeta(5).outputItems(new ItemStack((ItemLike)Blocks.f_50031_, 12)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("activator_rail", new Object[0]).inputItems(TagPrefix.rod, GTMaterials.Iron, 12).inputItems(new ItemStack((ItemLike)Items.f_42398_, 2)).inputItems(new ItemStack((ItemLike)Blocks.f_50174_)).circuitMeta(5).outputItems(new ItemStack((ItemLike)Blocks.f_50285_, 12)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("minecart", new Object[0]).inputItems(TagPrefix.plate, GTMaterials.Iron, 3).inputItems(TagPrefix.ring, GTMaterials.Iron, 4).outputItems(new ItemStack((ItemLike)Items.f_42449_)).duration(100).EUt(4L).save(provider);
        VanillaRecipeHelper.addShapedRecipe(provider, "saddle", new ItemStack((ItemLike)Items.f_42450_), "LLL", "LCL", "RSR", Character.valueOf('L'), new ItemStack((ItemLike)Items.f_42454_), Character.valueOf('C'), ItemTags.f_215867_, Character.valueOf('R'), new UnificationEntry(TagPrefix.ring, GTMaterials.Iron), Character.valueOf('S'), new ItemStack((ItemLike)Items.f_42401_));
        GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("clay_from_dust", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Clay).inputFluids(GTMaterials.Water.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.f_42461_)).duration(600).EUt(24L).save(provider);
        GTRecipeTypes.AUTOCLAVE_RECIPES.recipeBuilder("clay_from_dust_distilled", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Clay).inputFluids(GTMaterials.DistilledWater.getFluid(250)).outputItems(new ItemStack((ItemLike)Items.f_42461_)).duration(300).EUt(24L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("redstone_block", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Redstone, 9).outputItems(new ItemStack((ItemLike)Blocks.f_50330_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("bone_block", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Bone, 9).outputItems(new ItemStack((ItemLike)Blocks.f_50453_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("purpur_block", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42731_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50492_, 4)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("magma_block", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42542_, 4)).outputItems(new ItemStack((ItemLike)Blocks.f_50450_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("slime_block", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42518_, 9)).outputItems(new ItemStack((ItemLike)Blocks.f_50374_)).duration(300).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("nether_wart_block", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42588_, 9)).circuitMeta(9).outputItems(new ItemStack((ItemLike)Blocks.f_50451_)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("prismarine", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42695_, 4)).circuitMeta(4).outputItems(new ItemStack((ItemLike)Blocks.f_50377_)).duration(100).EUt(2L).save(provider);
        GTRecipeTypes.PACKER_RECIPES.recipeBuilder("prismarine_bricks", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42695_, 9)).circuitMeta(9).outputItems(new ItemStack((ItemLike)Blocks.f_50378_)).duration(200).EUt(2L).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("eye_of_ender", new Object[0]).inputFluids(GTMaterials.Blaze.getFluid(144)).inputItems(TagPrefix.gem, GTMaterials.EnderPearl).outputItems(new ItemStack((ItemLike)Items.f_42545_)).duration(50).EUt(GTValues.VA[3]).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("blaze_rod", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Blaze, 4).outputItems(new ItemStack((ItemLike)Items.f_42585_)).save(provider);
        GTRecipeTypes.COMPRESSOR_RECIPES.recipeBuilder("mud_to_clay", new Object[0]).inputItems(Items.f_220216_).outputItems(Items.f_41983_).duration(40).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("ender_chest", new Object[0]).duration(100).EUt(4L).inputItems(new ItemStack((ItemLike)Blocks.f_50080_, 8)).inputItems(new ItemStack((ItemLike)Items.f_42545_)).outputItems(new ItemStack((ItemLike)Blocks.f_50265_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("armor_stand", new Object[0]).duration(30).EUt(GTValues.VA[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50405_, 1)).inputItems(new ItemStack((ItemLike)Items.f_42398_, 6)).outputItems(new ItemStack((ItemLike)Items.f_42650_)).save(provider);
        GTRecipeTypes.FLUID_SOLIDFICATION_RECIPES.recipeBuilder("candle", new Object[0]).inputFluids(GTMaterials.Wax.getFluid(144)).inputItems(new ItemStack((ItemLike)Items.f_42401_)).outputItems(new ItemStack((ItemLike)Blocks.f_152482_, 2)).duration(20).EUt(1L).save(provider);
        GTRecipeTypes.FORGE_HAMMER_RECIPES.recipeBuilder("disc_fragment_5", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_220217_)).outputItems(new ItemStack((ItemLike)Items.f_220218_, 9)).duration(100).EUt(6L).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("chest_minecart", new Object[0]).EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.f_42449_)).inputItems((TagKey<Item>)Tags.Items.CHESTS_WOODEN).outputItems(new ItemStack((ItemLike)Items.f_42519_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("furnace_minecart", new Object[0]).EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.f_42449_)).inputItems(new ItemStack((ItemLike)Blocks.f_50094_)).outputItems(new ItemStack((ItemLike)Items.f_42520_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("tnt_minecart", new Object[0]).EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.f_42449_)).inputItems(new ItemStack((ItemLike)Blocks.f_50077_)).outputItems(new ItemStack((ItemLike)Items.f_42693_)).save(provider);
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("hopper_minecart", new Object[0]).EUt(4L).duration(100).inputItems(new ItemStack((ItemLike)Items.f_42449_)).inputItems(new ItemStack((ItemLike)Blocks.f_50332_)).outputItems(new ItemStack((ItemLike)Items.f_42694_)).save(provider);
        VanillaRecipeHelper.addShapelessRecipe(provider, "hay_block_to_hay", new ItemStack((ItemLike)Items.f_42405_, 9), Items.f_42129_, Character.valueOf('k'));
        GTRecipeTypes.ASSEMBLER_RECIPES.recipeBuilder("conduit", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42716_)).inputItems(new ItemStack((ItemLike)Items.f_42715_, 8)).outputItems(new ItemStack((ItemLike)Blocks.f_50569_)).duration(200).EUt(16L).save(provider);
    }

    private static void mixingRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("fire_charge", new Object[0]).inputItems(TagPrefix.dust, GTMaterials.Coal).inputItems(TagPrefix.dust, GTMaterials.Gunpowder).inputItems(TagPrefix.dust, GTMaterials.Blaze).outputItems(new ItemStack((ItemLike)Items.f_42613_, 3)).duration(100).EUt(GTValues.VA[1]).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("coarse_dirt", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_49994_)).inputItems(new ItemStack((ItemLike)Blocks.f_50493_)).outputItems(new ItemStack((ItemLike)Blocks.f_50546_, 2)).duration(100).EUt(4L).save(provider);
        GTRecipeTypes.MIXER_RECIPES.recipeBuilder("mud", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50493_)).circuitMeta(1).inputFluids(GTMaterials.Water.getFluid(144)).outputItems(new ItemStack((ItemLike)Blocks.f_220864_, 1)).duration(100).EUt(4L).save(provider);
    }

    private static void dyeRecipes(Consumer<FinishedRecipe> provider) {
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("poppy_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50112_)).outputItems(new ItemStack((ItemLike)Items.f_42497_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("blue_orchid_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50113_)).outputItems(new ItemStack((ItemLike)Items.f_42538_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("allium_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50114_)).outputItems(new ItemStack((ItemLike)Items.f_42537_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("azure_bluet_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50115_)).outputItems(new ItemStack((ItemLike)Items.f_42491_)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("red_tulip_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50116_)).outputItems(new ItemStack((ItemLike)Items.f_42497_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("orange_tulip_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50117_)).outputItems(new ItemStack((ItemLike)Items.f_42536_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("white_tulip_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50118_)).outputItems(new ItemStack((ItemLike)Items.f_42491_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pink_tulip_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50119_)).outputItems(new ItemStack((ItemLike)Items.f_42489_)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("oxeye_daisy_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50120_)).outputItems(new ItemStack((ItemLike)Items.f_42491_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("dandelion_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50111_)).outputItems(new ItemStack((ItemLike)Items.f_42539_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("cornflower_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50121_)).outputItems(new ItemStack((ItemLike)Items.f_42494_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lily_of_the_valley_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50071_)).outputItems(new ItemStack((ItemLike)Items.f_42535_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("wither_rose_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50070_)).outputItems(new ItemStack((ItemLike)Items.f_42498_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("sunflower_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50355_)).outputItems(new ItemStack((ItemLike)Items.f_42539_, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lilac_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50356_)).outputItems(new ItemStack((ItemLike)Items.f_42537_, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("rose_bush_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50357_)).outputItems(new ItemStack((ItemLike)Items.f_42497_, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("peony_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Blocks.f_50358_)).outputItems(new ItemStack((ItemLike)Items.f_42489_, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("beetroot_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42732_)).outputItems(new ItemStack((ItemLike)Items.f_42497_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("torchflower_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_271471_)).outputItems(new ItemStack((ItemLike)Items.f_42536_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pitcher_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_276698_)).outputItems(new ItemStack((ItemLike)Items.f_42492_, 3)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("pink_petals_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_271209_)).outputItems(new ItemStack((ItemLike)Items.f_42489_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("sea_pickle_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_41868_)).outputItems(new ItemStack((ItemLike)Items.f_42540_, 2)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("white_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42499_)).outputItems(new ItemStack((ItemLike)Items.f_42535_, 1)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("lapis_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42534_)).outputItems(new ItemStack((ItemLike)Items.f_42494_)).save(provider);
        GTRecipeTypes.EXTRACTOR_RECIPES.recipeBuilder("ink_dye", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42532_)).outputItems(new ItemStack((ItemLike)Items.f_42498_)).save(provider);
        GTRecipeTypes.CHEMICAL_BATH_RECIPES.recipeBuilder("dark_prismarine", new Object[0]).inputItems(new ItemStack((ItemLike)Items.f_42695_, 8)).inputFluids(GTMaterials.DyeBlack.getFluid(144)).outputItems(new ItemStack((ItemLike)Blocks.f_50379_)).duration(20).EUt(GTValues.VA[0]).save(provider);
    }
}

