/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.common.machine.multiblock.part.FluidHatchPartMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.feature.IGridConnectedMachine;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHolder;
import com.gregtechceu.gtceu.integration.ae2.utils.SerializableManagedGridNode;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.EnumSet;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class MEHatchPartMachine
extends FluidHatchPartMachine
implements IGridConnectedMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEHatchPartMachine.class, FluidHatchPartMachine.MANAGED_FIELD_HOLDER);
    protected static final int CONFIG_SIZE = 16;
    @Persisted
    protected final GridNodeHolder nodeHolder = this.createNodeHolder();
    @DescSynced
    protected boolean isOnline;
    protected final IActionSource actionSource = IActionSource.ofMachine(() -> ((SerializableManagedGridNode)this.nodeHolder.getMainNode()).getNode());

    public MEHatchPartMachine(IMachineBlockEntity holder, IO io, Object ... args) {
        super(holder, 9, io, 8000, 16, args);
    }

    protected GridNodeHolder createNodeHolder() {
        return new GridNodeHolder(this);
    }

    public IManagedGridNode getMainNode() {
        return this.nodeHolder.getMainNode();
    }

    @Override
    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        IGridConnectedMachine.super.onMainNodeStateChanged(reason);
        this.updateTankSubscription();
    }

    @Override
    protected void updateTankSubscription() {
        if (this.shouldSubscribe()) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, () -> this.autoIO());
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected boolean shouldSubscribe() {
        return this.isWorkingEnabled() && this.isOnline();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.getMainNode().setExposedOnSides(EnumSet.of(newFacing));
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public boolean isOnline() {
        return this.isOnline;
    }

    @Override
    public void setOnline(boolean isOnline) {
        this.isOnline = isOnline;
    }
}

