/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IInteractedMachine;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.list.AEListGridWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEBusPartMachine;
import com.gregtechceu.gtceu.integration.ae2.utils.KeyStorage;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.item.ItemStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MEOutputBusPartMachine
extends MEBusPartMachine
implements IMachineLife,
IInteractedMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEOutputBusPartMachine.class, MEBusPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private KeyStorage internalBuffer;

    public MEOutputBusPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.OUT, args);
    }

    @Override
    protected NotifiableItemStackHandler createInventory(Object ... args) {
        this.internalBuffer = new KeyStorage();
        return new InaccessibleInfiniteHandler(this);
    }

    @Override
    public void onMachineRemoved() {
        IGrid grid = this.getMainNode().getGrid();
        if (grid != null && !this.internalBuffer.isEmpty()) {
            for (Object2LongMap.Entry<AEKey> entry : this.internalBuffer) {
                grid.getStorageService().getInventory().insert((AEKey)entry.getKey(), entry.getLongValue(), Actionable.MODULATE, this.actionSource);
            }
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected boolean shouldSubscribe() {
        return super.shouldSubscribe() && !this.internalBuffer.storage.isEmpty();
    }

    @Override
    public void autoIO() {
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null && !this.internalBuffer.isEmpty()) {
                this.internalBuffer.insertInventory(grid.getStorageService().getInventory(), this.actionSource);
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 170, 65);
        group.addWidget((Widget)new LabelWidget(5, 0, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new LabelWidget(5, 10, "gtceu.gui.waiting_list"));
        group.addWidget((Widget)new AEListGridWidget.Item(5, 20, 3, this.internalBuffer));
        return group;
    }

    private class InaccessibleInfiniteHandler
    extends NotifiableItemStackHandler {
        public InaccessibleInfiniteHandler(MetaMachine holder) {
            super(holder, 1, IO.OUT, IO.NONE, x$0 -> {
                MEOutputBusPartMachine mEOutputBusPartMachine = MEOutputBusPartMachine.this;
                Objects.requireNonNull(mEOutputBusPartMachine);
                return mEOutputBusPartMachine.new ItemStackHandlerDelegate((Integer)x$0);
            });
            MEOutputBusPartMachine.this.internalBuffer.setOnContentsChanged(this::onContentsChanged);
        }
    }

    private class ItemStackHandlerDelegate
    extends CustomItemStackHandler {
        public ItemStackHandlerDelegate(Integer integer) {
        }

        public int getSlots() {
            return Short.MAX_VALUE;
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            AEItemKey key = AEItemKey.of((ItemStack)stack);
            int count = stack.m_41613_();
            long oldValue = MEOutputBusPartMachine.this.internalBuffer.storage.getOrDefault((Object)key, 0L);
            long changeValue = Math.min(Long.MAX_VALUE - oldValue, (long)count);
            if (changeValue > 0L) {
                if (!simulate) {
                    MEOutputBusPartMachine.this.internalBuffer.storage.put((Object)key, oldValue + changeValue);
                    MEOutputBusPartMachine.this.internalBuffer.onChanged();
                }
                return stack.m_255036_((int)((long)count - changeValue));
            }
            return ItemStack.f_41583_;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public ItemStackHandlerDelegate() {
        }
    }
}

