/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.slot;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.integration.ae2.slot.ExportOnlyAEItemSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlotList;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportOnlyAEItemList
extends NotifiableItemStackHandler
implements IConfigurableSlotList {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ExportOnlyAEItemList.class, NotifiableItemStackHandler.MANAGED_FIELD_HOLDER);
    @Persisted
    protected ExportOnlyAEItemSlot[] inventory;
    private CustomItemStackHandler itemHandler;

    public ExportOnlyAEItemList(MetaMachine holder, int slots) {
        this(holder, slots, ExportOnlyAEItemSlot::new);
    }

    public ExportOnlyAEItemList(MetaMachine holder, int slots, Supplier<ExportOnlyAEItemSlot> slotFactory) {
        super(holder, 0, IO.IN);
        this.inventory = new ExportOnlyAEItemSlot[slots];
        for (int i = 0; i < slots; ++i) {
            this.inventory[i] = slotFactory.get();
        }
        for (ExportOnlyAEItemSlot slot : this.inventory) {
            slot.setOnContentsChanged(this::onContentsChanged);
        }
    }

    public CustomItemStackHandler getHandler() {
        if (this.itemHandler == null) {
            this.itemHandler = new ItemStackHandlerDelegate(this.inventory);
        }
        return this.itemHandler;
    }

    @Override
    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    @Override
    public int getSlots() {
        return this.inventory.length;
    }

    @Override
    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.inventory.length) {
            return this.inventory[slot].getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    @Override
    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Override
    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot >= 0 && slot < this.inventory.length) {
            return this.inventory[slot].extractItem(0, amount, simulate);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
        return NotifiableItemStackHandler.handleRecipe(io, recipe, left, simulate, this.handlerIO, this.getHandler());
    }

    @Override
    public IConfigurableSlot getConfigurableSlot(int index) {
        return this.inventory[index];
    }

    @Override
    public int getConfigurableSlots() {
        return this.inventory.length;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public ExportOnlyAEItemSlot[] getInventory() {
        return this.inventory;
    }

    private static class ItemStackHandlerDelegate
    extends CustomItemStackHandler {
        private final ExportOnlyAEItemSlot[] inventory;

        public ItemStackHandlerDelegate(ExportOnlyAEItemSlot[] inventory) {
            this.inventory = inventory;
        }

        public int getSlots() {
            return this.inventory.length;
        }

        public ItemStack getStackInSlot(int slot) {
            return this.inventory[slot].getStackInSlot(0);
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount == 0) {
                return ItemStack.f_41583_;
            }
            this.validateSlotIndex(slot);
            return this.inventory[slot].extractItem(0, amount, simulate);
        }

        protected void validateSlotIndex(int slot) {
            if (slot < 0 || slot >= this.getSlots()) {
                throw new RuntimeException("Slot " + slot + " not in valid range - [0," + this.getSlots() + ")");
            }
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isItemValid(int slot, ItemStack stack) {
            return false;
        }
    }
}

