/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public abstract class CapabilityBlockProvider<C>
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public final ResourceLocation uid;

    protected CapabilityBlockProvider(ResourceLocation uid) {
        this.uid = uid;
    }

    @Nullable
    protected abstract C getCapability(Level var1, BlockPos var2, @Nullable Direction var3);

    protected abstract void write(CompoundTag var1, C var2);

    protected abstract void addTooltip(CompoundTag var1, ITooltip var2, Player var3, BlockAccessor var4, BlockEntity var5, IPluginConfig var6);

    protected boolean allowDisplaying(C capability) {
        return true;
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor block, IPluginConfig config) {
        BlockEntity be = block.getBlockEntity();
        if (be == null) {
            return;
        }
        Direction side = block.getSide();
        CompoundTag capData = null;
        if (side != null) {
            capData = block.getServerData().m_128469_(this.uid.toString()).m_128469_(side.m_122433_());
        }
        if (side == null || capData.m_128456_()) {
            capData = block.getServerData().m_128469_(this.uid.toString()).m_128469_("null");
        }
        this.addTooltip(capData, tooltip, block.getPlayer(), block, be, config);
    }

    public void appendServerData(CompoundTag data, BlockAccessor blockAccessor) {
        CompoundTag capData = data.m_128469_(this.uid.toString());
        C capability = this.getCapability(blockAccessor.getLevel(), blockAccessor.getPosition(), null);
        if (capability != null && this.allowDisplaying(capability)) {
            CompoundTag tag = new CompoundTag();
            this.write(tag, capability);
            capData.m_128365_("null", (Tag)tag);
        }
        for (Direction value : GTUtil.DIRECTIONS) {
            capability = this.getCapability(blockAccessor.getLevel(), blockAccessor.getPosition(), value);
            if (capability == null || !this.allowDisplaying(capability)) continue;
            CompoundTag tag = new CompoundTag();
            this.write(tag, capability);
            capData.m_128365_(value.m_122433_(), (Tag)tag);
        }
        data.m_128365_(this.uid.toString(), (Tag)capData);
    }

    protected float getProgress(long progress, long maxProgress) {
        return maxProgress == 0L ? 0.0f : (float)((double)progress / (double)maxProgress);
    }

    public ResourceLocation getUid() {
        return this.uid;
    }
}

