/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.integration.jade.GTElementHelper;
import com.gregtechceu.gtceu.integration.jade.provider.CapabilityBlockProvider;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.util.FluidTextHelper;

public class RecipeOutputProvider
extends CapabilityBlockProvider<RecipeLogic> {
    public RecipeOutputProvider() {
        super(GTCEu.id("recipe_output_info"));
    }

    @Override
    @Nullable
    protected RecipeLogic getCapability(Level level, BlockPos pos, @Nullable Direction side) {
        return GTCapabilityHelper.getRecipeLogic(level, pos, side);
    }

    @Override
    protected void write(CompoundTag data, RecipeLogic recipeLogic) {
        if (recipeLogic.isWorking()) {
            data.m_128379_("Working", recipeLogic.isWorking());
            GTRecipe recipe = recipeLogic.getLastRecipe();
            if (recipe != null) {
                ListTag itemTags = new ListTag();
                for (ItemStack stack : RecipeHelper.getOutputItems(recipe)) {
                    if (stack == null || stack.m_41619_()) continue;
                    CompoundTag itemTag = new CompoundTag();
                    GTUtil.saveItemStack(stack, itemTag);
                    itemTags.add((Object)itemTag);
                }
                if (!itemTags.isEmpty()) {
                    data.m_128365_("OutputItems", (Tag)itemTags);
                }
                ListTag fluidTags = new ListTag();
                for (FluidStack stack : RecipeHelper.getOutputFluids(recipe)) {
                    if (stack == null || stack.isEmpty()) continue;
                    CompoundTag fluidTag = new CompoundTag();
                    stack.writeToNBT(fluidTag);
                    fluidTags.add((Object)fluidTag);
                }
                if (!fluidTags.isEmpty()) {
                    data.m_128365_("OutputFluids", (Tag)fluidTags);
                }
            }
        }
    }

    @Override
    protected void addTooltip(CompoundTag capData, ITooltip tooltip, Player player, BlockAccessor block, BlockEntity blockEntity, IPluginConfig config) {
        if (capData.m_128471_("Working")) {
            ListTag itemTags;
            ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
            if (capData.m_128425_("OutputItems", 9) && !(itemTags = capData.m_128437_("OutputItems", 10)).isEmpty()) {
                for (Tag tag : itemTags) {
                    CompoundTag tCompoundTag;
                    ItemStack stack;
                    if (!(tag instanceof CompoundTag) || (stack = GTUtil.loadItemStack(tCompoundTag = (CompoundTag)tag)).m_41619_()) continue;
                    outputItems.add(stack);
                }
            }
            ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
            if (capData.m_128425_("OutputFluids", 9)) {
                ListTag fluidTags = capData.m_128437_("OutputFluids", 10);
                for (Tag tag : fluidTags) {
                    CompoundTag tCompoundTag;
                    FluidStack stack;
                    if (!(tag instanceof CompoundTag) || (stack = FluidStack.loadFluidStackFromNBT((CompoundTag)(tCompoundTag = (CompoundTag)tag))).isEmpty()) continue;
                    outputFluids.add(stack);
                }
            }
            if (!outputItems.isEmpty() || !outputFluids.isEmpty()) {
                tooltip.add((Component)Component.m_237115_((String)"gtceu.top.recipe_output"));
            }
            this.addItemTooltips(tooltip, outputItems);
            this.addFluidTooltips(tooltip, outputFluids);
        }
    }

    private void addItemTooltips(ITooltip iTooltip, List<ItemStack> outputItems) {
        IElementHelper helper = iTooltip.getElementHelper();
        for (ItemStack itemOutput : outputItems) {
            if (itemOutput == null || itemOutput.m_41619_()) continue;
            int count = itemOutput.m_41613_();
            itemOutput.m_41764_(1);
            iTooltip.add(helper.smallItem(itemOutput));
            MutableComponent text = Component.m_237113_((String)" ").m_130946_(String.valueOf(count)).m_130946_("\u00d7 ").m_7220_(this.getItemName(itemOutput)).m_130940_(ChatFormatting.WHITE);
            iTooltip.append((Component)text);
        }
    }

    private void addFluidTooltips(ITooltip iTooltip, List<FluidStack> outputFluids) {
        for (FluidStack fluidOutput : outputFluids) {
            if (fluidOutput == null || fluidOutput.isEmpty()) continue;
            iTooltip.add(GTElementHelper.smallFluid(this.getFluid(fluidOutput)));
            MutableComponent text = Component.m_237113_((String)" ").m_130946_(FluidTextHelper.getUnicodeMillibuckets((long)fluidOutput.getAmount(), (boolean)true)).m_130946_(" ").m_7220_(this.getFluidName(fluidOutput)).m_130940_(ChatFormatting.WHITE);
            iTooltip.append((Component)text);
        }
    }

    private Component getItemName(ItemStack stack) {
        return ComponentUtils.m_130748_((Component)stack.m_41720_().m_41466_()).m_130940_(ChatFormatting.WHITE);
    }

    private Component getFluidName(FluidStack stack) {
        return ComponentUtils.m_130748_((Component)stack.getDisplayName()).m_130940_(ChatFormatting.WHITE);
    }

    private JadeFluidObject getFluid(FluidStack stack) {
        return JadeFluidObject.of((Fluid)stack.getFluid(), (long)stack.getAmount());
    }
}

