/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.common.machine.electric.TransformerMachine;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class TransformerBlockProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public ResourceLocation getUid() {
        return GTCEu.id("transformer");
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        IMachineBlockEntity blockEntity;
        MetaMachine machine;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (machine = (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof TransformerMachine) {
            TransformerMachine transformer = (TransformerMachine)machine;
            compoundTag.m_128405_("side", transformer.getFrontFacing().m_122411_());
            compoundTag.m_128379_("transformUp", transformer.isTransformUp());
            compoundTag.m_128405_("baseAmp", transformer.getBaseAmp());
            compoundTag.m_128405_("baseVoltage", transformer.getTier());
        }
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IMachineBlockEntity blockEntity;
        MetaMachine machine;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (machine = (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof TransformerMachine) {
            TransformerMachine transformer = (TransformerMachine)machine;
            boolean transformUp = blockAccessor.getServerData().m_128471_("transformUp");
            int voltage = blockAccessor.getServerData().m_128451_("baseVoltage");
            int amp = blockAccessor.getServerData().m_128451_("baseAmp");
            if (transformUp) {
                tooltip.add((Component)Component.m_237110_((String)"gtceu.top.transform_up", (Object[])new Object[]{GTValues.VNF[voltage] + " \u00a7r(" + amp * 4 + "A) -> " + GTValues.VNF[voltage + 1] + " \u00a7r(" + amp + "A)"}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)"gtceu.top.transform_down", (Object[])new Object[]{GTValues.VNF[voltage + 1] + " \u00a7r(" + amp + "A) -> " + GTValues.VNF[voltage] + " \u00a7r(" + amp * 4 + "A)"}));
            }
            if (((BlockHitResult)blockAccessor.getHitResult()).m_82434_() == Direction.m_122376_((int)blockAccessor.getServerData().m_128451_("side"))) {
                tooltip.add((Component)Component.m_237110_((String)(transformUp ? "gtceu.top.transform_output" : "gtceu.top.transform_input"), (Object[])new Object[]{GTValues.VNF[voltage + 1] + " \u00a7r(" + amp + "A)"}));
            } else {
                tooltip.add((Component)Component.m_237110_((String)(transformUp ? "gtceu.top.transform_input" : "gtceu.top.transform_output"), (Object[])new Object[]{GTValues.VNF[voltage] + " \u00a7r(" + amp * 4 + "A)"}));
            }
        }
    }
}

