/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.SimpleTieredMachine;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.registry.GTRegistration;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.MachineFunctionPresets;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class SimpleMachineBuilder
extends MachineBuilder<MachineDefinition> {
    public transient Int2IntFunction tankScalingFunction = GTMachines.defaultTankSizeFunction;

    public SimpleMachineBuilder(String name, Function<IMachineBlockEntity, MetaMachine> machineConstructor) {
        super(GTRegistration.REGISTRATE, name, MachineDefinition::createDefinition, machineConstructor, MetaMachineBlock::new, MetaMachineItem::new, MetaMachineBlockEntity::createBlockEntity);
    }

    public SimpleMachineBuilder tankScalingFunction(Function<Integer, Double> tankScalingFunction) {
        this.tankScalingFunction = tier -> ((Double)tankScalingFunction.apply(tier)).intValue();
        this.metaMachine(holder -> new SimpleTieredMachine((IMachineBlockEntity)holder, this.tier(), this.tankScalingFunction, new Object[0]));
        return this;
    }

    public SimpleMachineBuilder tier(int tier) {
        return (SimpleMachineBuilder)super.tier(tier);
    }

    private static SimpleMachineBuilder[] simpleMachines(String name, BiConsumer<SimpleMachineBuilder, Integer> builderConsumer, Integer ... tiers) {
        SimpleMachineBuilder[] builders = new SimpleMachineBuilder[GTValues.TIER_COUNT];
        Integer[] integerArray = tiers;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int tier = integerArray[i];
            SimpleMachineBuilder register = new SimpleMachineBuilder(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, holder -> new SimpleTieredMachine((IMachineBlockEntity)holder, tier, GTMachines.defaultTankSizeFunction, new Object[0])).tier(tier);
            builderConsumer.accept(register, tier);
            builders[tier] = register;
        }
        return builders;
    }

    public static void simple(SimpleMachineBuilder builder, int tier) {
        builder.tier(tier).langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(builder.name), GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).recipeModifier(GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).workableTieredHullRenderer(GTCEu.id("block/machines/" + builder.name)).tooltips(GTMachines.explosion());
    }

    public static MachineBuilder<MachineDefinition> create(String name, Object ... args) {
        MachineBuilder[] builders = SimpleMachineBuilder.simpleMachines(name, SimpleMachineBuilder::simple, MachineFunctionPresets.mapTierArray(args));
        return MachineFunctionPresets.builder((String)name, (MachineBuilder[])builders, SimpleMachineBuilder.class, MachineDefinition::createDefinition, MetaMachineBlock::new, MetaMachineBlockEntity::createBlockEntity);
    }
}

