/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map;

import com.gregtechceu.gtceu.integration.map.IWaypointHandler;
import com.gregtechceu.gtceu.integration.map.journeymap.JourneymapWaypointHandler;
import com.gregtechceu.gtceu.integration.map.xaeros.XaeroWaypointHandler;
import com.lowdragmc.lowdraglib.Platform;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class WaypointManager {
    public static ResourceKey<Level> currentDimension;
    private static boolean active;
    private static final Set<IWaypointHandler> handlers;
    private static final Object2ObjectMap<String, WaypointKey> waypoints;

    public static void init() {
        if (Platform.isModLoaded((String)"xaerominimap")) {
            WaypointManager.registerWaypointHandler(new XaeroWaypointHandler());
            active = true;
        }
        if (Platform.isModLoaded((String)"journeymap")) {
            WaypointManager.registerWaypointHandler(new JourneymapWaypointHandler());
            active = true;
        }
    }

    public static void updateDimension(LevelAccessor dim) {
        if (dim instanceof ClientLevel) {
            ClientLevel level = (ClientLevel)dim;
            currentDimension = level.m_46472_();
        }
    }

    public static void setWaypoint(String key, String name, int color, ResourceKey<Level> dim, int x, int y, int z) {
        if (dim == null) {
            dim = currentDimension;
        }
        for (IWaypointHandler handler : handlers) {
            handler.setWaypoint(key, name, color, dim, x, y, z);
        }
        waypoints.put((Object)key, (Object)new WaypointKey(dim, x, y, z));
    }

    public static void removeWaypoint(String key) {
        for (IWaypointHandler handler : handlers) {
            handler.removeWaypoint(key);
        }
        waypoints.remove((Object)key);
    }

    public static boolean toggleWaypoint(String key, String name, int color, ResourceKey<Level> dim, int x, int y, int z) {
        if (dim == null) {
            dim = currentDimension;
        }
        if (new WaypointKey(dim, x, y, z).equals(waypoints.get((Object)key))) {
            WaypointManager.removeWaypoint(key);
            return false;
        }
        WaypointManager.setWaypoint(key, name, color, dim, x, y, z);
        return true;
    }

    public static void registerWaypointHandler(IWaypointHandler handler) {
        handlers.add(handler);
    }

    public static boolean isActive() {
        return active;
    }

    static {
        active = false;
        handlers = new HashSet<IWaypointHandler>();
        waypoints = new Object2ObjectArrayMap();
    }

    private static class WaypointKey {
        ResourceKey<Level> dim;
        int x;
        int y;
        int z;

        public WaypointKey(ResourceKey<Level> dim, int x, int y, int z) {
            this.dim = dim;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WaypointKey that = (WaypointKey)o;
            return this.dim == that.dim && this.x == that.x && this.y == that.y && this.z == that.z;
        }

        public int hashCode() {
            return Objects.hash(this.dim, this.x, this.y, this.z);
        }
    }
}

