/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache;

import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.integration.map.cache.DimensionCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public abstract class WorldCache {
    protected final Map<ResourceKey<Level>, DimensionCache> cache = new HashMap<ResourceKey<Level>, DimensionCache>();

    public boolean addVein(ResourceKey<Level> dim, int gridX, int gridZ, GeneratedVeinMetadata vein) {
        if (!this.cache.containsKey(dim)) {
            this.cache.put(dim, new DimensionCache());
        }
        return this.cache.get(dim).addVein(gridX, gridZ, vein);
    }

    public List<GeneratedVeinMetadata> getNearbyVeins(ResourceKey<Level> dim, BlockPos pos, int blockRadius) {
        if (this.cache.containsKey(dim)) {
            return this.cache.get(dim).getNearbyVeins(pos, blockRadius);
        }
        return new ArrayList<GeneratedVeinMetadata>();
    }

    public List<GeneratedVeinMetadata> getVeinsInArea(ResourceKey<Level> dim, int[] bounds) {
        if (this.cache.containsKey(dim)) {
            return this.cache.get(dim).getVeinsInBounds(new BlockPos(bounds[0], 0, bounds[1]), new BlockPos(bounds[0] + bounds[2], 0, bounds[1] + bounds[3]));
        }
        return new ArrayList<GeneratedVeinMetadata>();
    }

    public void clear() {
        this.cache.clear();
    }
}

