/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.rei;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.rei.multipage.MultiblockInfoDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.oreprocessing.GTOreProcessingDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.orevein.GTBedrockFluidDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.orevein.GTBedrockOreDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.orevein.GTOreVeinDisplayCategory;
import com.gregtechceu.gtceu.integration.rei.recipe.GTRecipeREICategory;
import com.lowdragmc.lowdraglib.Platform;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.forge.REIPluginClient;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@REIPluginClient
public class GTREIPlugin
implements REIClientPlugin {
    public void registerCategories(CategoryRegistry registry) {
        registry.add((DisplayCategory)new MultiblockInfoDisplayCategory());
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            registry.add((DisplayCategory)new GTOreProcessingDisplayCategory());
        }
        registry.add((DisplayCategory)new GTOreVeinDisplayCategory());
        registry.add((DisplayCategory)new GTBedrockFluidDisplayCategory());
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            registry.add((DisplayCategory)new GTBedrockOreDisplayCategory());
        }
        for (GTRecipeCategory category : GTRegistries.RECIPE_CATEGORIES) {
            if (!Platform.isDevEnv() && !category.isXEIVisible()) continue;
            registry.add((DisplayCategory)new GTRecipeREICategory(category));
        }
        GTRecipeREICategory.registerWorkStations(registry);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingDisplayCategory.registerWorkstations(registry);
        }
        GTOreVeinDisplayCategory.registerWorkstations(registry);
        GTBedrockFluidDisplayCategory.registerWorkstations(registry);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreDisplayCategory.registerWorkstations(registry);
        }
        for (MachineDefinition definition : GTMachines.ELECTRIC_FURNACE) {
            if (definition == null) continue;
            registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemStack)definition.asStack())});
        }
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemStack)((MachineDefinition)GTMachines.STEAM_FURNACE.left()).asStack())});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemStack)((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asStack())});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemStack)GTMachines.STEAM_OVEN.asStack())});
        registry.addWorkstations(BuiltinPlugin.SMELTING, new EntryStack[]{EntryStacks.of((ItemStack)GTMachines.MULTI_SMELTER.asStack())});
        registry.addWorkstations(GTRecipeREICategory.CATEGORIES.apply(GTRecipeCategory.of(GTRecipeTypes.CHEMICAL_RECIPES)), new EntryStack[]{EntryStacks.of((ItemStack)GTMachines.LARGE_CHEMICAL_REACTOR.asStack())});
    }

    public void registerDisplays(DisplayRegistry registry) {
        GTRecipeREICategory.registerDisplays(registry);
        MultiblockInfoDisplayCategory.registerDisplays(registry);
        if (!ConfigHolder.INSTANCE.compat.hideOreProcessingDiagrams) {
            GTOreProcessingDisplayCategory.registerDisplays(registry);
        }
        GTOreVeinDisplayCategory.registerDisplays(registry);
        GTBedrockFluidDisplayCategory.registerDisplays(registry);
        if (ConfigHolder.INSTANCE.machines.doBedrockOres) {
            GTBedrockOreDisplayCategory.registerDisplays(registry);
        }
    }

    public void registerCollapsibleEntries(CollapsibleEntryRegistry registry) {
        for (GTToolType gTToolType : GTToolType.getTypes().values()) {
            registry.group(GTCEu.id("tool/" + gTToolType.name), (Component)Component.m_237115_((String)("gtceu.tool.class." + gTToolType.name)), (List)EntryIngredients.ofItemTag(gTToolType.itemTags.get(0)));
        }
        for (Map.Entry entry : GTBlocks.MATERIAL_BLOCKS.columnMap().entrySet()) {
            Map value = (Map)entry.getValue();
            if (value.size() <= 1) continue;
            Material material = (Material)entry.getKey();
            ArrayList<ItemLike> items = new ArrayList<ItemLike>();
            for (Map.Entry t : value.entrySet()) {
                String name = ((TagPrefix)t.getKey()).name;
                if (Objects.equals(name, TagPrefix.frameGt.name) || Objects.equals(name, TagPrefix.block.name) || Objects.equals(name, TagPrefix.rawOreBlock.name)) continue;
                items.add((ItemLike)t.getValue());
            }
            String name = material.getName();
            String label = GTREIPlugin.toUpperAllWords(name.replace("_", " "));
            registry.group(GTCEu.id("ore/" + name), (Component)Component.m_237110_((String)"tagprefix.stone", (Object[])new Object[]{label}), (List)EntryIngredients.ofItems(items));
        }
    }

    private static String toUpperAllWords(String text) {
        StringBuilder result = new StringBuilder();
        result.append(text.substring(0, 1).toUpperCase());
        for (int i = 1; i < text.length(); ++i) {
            if (" ".equals(text.substring(i - 1, i))) {
                result.append(text.substring(i, i + 1).toUpperCase());
                continue;
            }
            result.append(text.charAt(i));
        }
        return result.toString();
    }
}

