/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.top.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import mcjty.theoneprobe.api.CompoundText;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mcjty.theoneprobe.apiimpl.styles.ItemStyle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public class AutoOutputInfoProvider
implements IProbeInfoProvider {
    public ResourceLocation getID() {
        return GTCEu.id("auto_output_info");
    }

    public void addProbeInfo(ProbeMode probeMode, IProbeInfo iProbeInfo, Player player, Level level, BlockState blockState, IProbeHitData iProbeHitData) {
        MetaMachine direction;
        BlockPos pos = iProbeHitData.getPos();
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, pos);
        if (metaMachine instanceof IAutoOutputItem) {
            IAutoOutputItem outputItem = (IAutoOutputItem)((Object)metaMachine);
            direction = outputItem.getOutputFacingItems();
            this.addAutoOutputInfo(iProbeInfo, player, level, pos, (Direction)direction, "gtceu.top.item_auto_output", outputItem.isAllowInputFromOutputSideItems(), outputItem.isAutoOutputItems());
        }
        if ((direction = MetaMachine.getMachine((BlockGetter)level, pos)) instanceof IAutoOutputFluid) {
            IAutoOutputFluid outputFluid = (IAutoOutputFluid)((Object)direction);
            direction = outputFluid.getOutputFacingFluids();
            this.addAutoOutputInfo(iProbeInfo, player, level, pos, (Direction)direction, "gtceu.top.item_auto_output", outputFluid.isAllowInputFromOutputSideFluids(), outputFluid.isAutoOutputFluids());
        }
    }

    private void addAutoOutputInfo(IProbeInfo iProbeInfo, Player player, Level level, BlockPos blockPos, Direction direction, String text, boolean allowInput, boolean auto) {
        if (direction != null) {
            BlockPos pos;
            ItemStack block;
            IProbeInfo horizontalPane = iProbeInfo.horizontal(iProbeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER));
            horizontalPane.text(CompoundText.create().info((Component)Component.m_237110_((String)text, (Object[])new Object[]{StringUtils.capitalize((String)direction.m_122433_()) + " "})));
            if (player.m_6144_() && level != null && !(block = level.m_8055_(pos = blockPos.m_121945_(direction)).m_60734_().m_5456_().m_7968_()).m_41619_()) {
                horizontalPane.item(block, new ItemStyle().width(16).height(16)).text(" ");
            }
            if (allowInput || auto) {
                CompoundText compoundText = CompoundText.create().text("(");
                if (auto) {
                    compoundText.ok((Component)Component.m_237115_((String)"gtceu.top.auto_output"));
                }
                if (allowInput && auto) {
                    compoundText.style(TextStyleClass.INFO).text("/");
                }
                if (allowInput) {
                    compoundText.ok((Component)Component.m_237115_((String)"gtceu.top.allow_output_input"));
                }
                compoundText.style(TextStyleClass.INFO).text(")");
                horizontalPane.text(compoundText);
            }
        }
    }
}

