/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import it.unimi.dsi.fastutil.Hash;
import java.util.Objects;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public interface ItemStackHashStrategy
extends Hash.Strategy<ItemStack> {
    public static ItemStackHashStrategyBuilder builder() {
        return new ItemStackHashStrategyBuilder();
    }

    public static ItemStackHashStrategy comparingAll() {
        return ItemStackHashStrategy.builder().compareItem(true).compareCount(true).compareTag(true).build();
    }

    public static ItemStackHashStrategy comparingAllButCount() {
        return ItemStackHashStrategy.builder().compareItem(true).compareTag(true).build();
    }

    public static class ItemStackHashStrategyBuilder {
        private boolean item;
        private boolean count;
        private boolean tag;

        public ItemStackHashStrategyBuilder compareItem(boolean choice) {
            this.item = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareCount(boolean choice) {
            this.count = choice;
            return this;
        }

        public ItemStackHashStrategyBuilder compareTag(boolean choice) {
            this.tag = choice;
            return this;
        }

        public ItemStackHashStrategy build() {
            return new ItemStackHashStrategy(){

                public int hashCode(@Nullable ItemStack o) {
                    return o == null || o.m_41619_() ? 0 : Objects.hash(item ? o.m_41720_() : null, count ? Integer.valueOf(o.m_41613_()) : null, tag ? o.m_41783_() : null);
                }

                public boolean equals(@Nullable ItemStack a, @Nullable ItemStack b) {
                    if (a == null || a.m_41619_()) {
                        return b == null || b.m_41619_();
                    }
                    if (b == null || b.m_41619_()) {
                        return false;
                    }
                    return !(item && a.m_41720_() != b.m_41720_() || count && a.m_41613_() != b.m_41613_() || tag && !Objects.equals(a.m_41783_(), b.m_41783_()));
                }
            };
        }
    }
}

