/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import invtweaks.InvTweaksMod;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.Arrays;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public class ContOverride {
    private final int x;
    private final int y;
    @Nullable
    private final IntList sortRange;
    private final String sortRangeSpec;

    public ContOverride(int x, int y, String sortRangeSpec) {
        this.x = x;
        this.y = y;
        this.sortRangeSpec = sortRangeSpec;
        IntLists.EmptyList tmp = null;
        if (sortRangeSpec.isEmpty()) {
            tmp = IntLists.EMPTY_LIST;
        } else if (!sortRangeSpec.equalsIgnoreCase("default")) {
            try {
                tmp = (IntList)Arrays.stream(sortRangeSpec.split("\\s*,\\s*")).flatMapToInt(str -> {
                    String[] rangeSpec = str.split("\\s*-\\s*");
                    return IntStream.rangeClosed(Integer.parseInt(rangeSpec[0]), Integer.parseInt(rangeSpec[1]));
                }).collect(IntArrayList::new, IntList::add, IntList::addAll);
            }
            catch (NumberFormatException e) {
                InvTweaksMod.LOGGER.warn("Invalid slot spec: " + sortRangeSpec);
                tmp = IntLists.EMPTY_LIST;
            }
        }
        this.sortRange = tmp;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    @Nullable
    public IntList getSortRange() {
        return this.sortRange;
    }

    public boolean isSortDisabled() {
        return this.sortRange != null && this.sortRange.isEmpty();
    }

    public CommentedConfig toConfig(String contClass) {
        CommentedConfig result = CommentedConfig.inMemory();
        result.set("containerClass", (Object)contClass);
        if (this.x != -1418392593) {
            result.set("x", (Object)this.x);
        }
        if (this.y != -1418392593) {
            result.set("y", (Object)this.y);
        }
        if (!this.sortRangeSpec.equalsIgnoreCase("default")) {
            result.set("sortRange", (Object)this.sortRangeSpec);
        }
        return result;
    }
}

