/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IEditModeConfig;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.Internal;
import mezz.jei.common.gui.JeiTooltip;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.SafeIngredientUtil;
import mezz.jei.gui.overlay.IngredientGridTooltipHelper;
import mezz.jei.gui.overlay.elements.IElement;
import mezz.jei.gui.overlay.elements.IElementRenderer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;

public class ElementRenderer<T>
implements IElementRenderer<T> {
    private static final int BLACKLIST_COLOR = -65536;
    private final IIngredientRenderer<T> ingredientRenderer;

    public ElementRenderer(IIngredientType<T> ingredientType) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        this.ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
    }

    @Override
    public void render(GuiGraphics guiGraphics, IElement<T> element, ImmutableRect2i area, int padding) {
        ITypedIngredient<T> typedIngredient = element.getTypedIngredient();
        if (Internal.getClientToggleState().isEditModeEnabled()) {
            ElementRenderer.renderEditMode(guiGraphics, area, padding, typedIngredient);
            RenderSystem.enableBlend();
        }
        int xPosition = area.getX() + padding;
        int yPosition = area.getY() + padding;
        SafeIngredientUtil.render(guiGraphics, this.ingredientRenderer, typedIngredient, xPosition, yPosition);
        element.renderExtras(guiGraphics, xPosition, yPosition);
    }

    private static <T> void renderEditMode(GuiGraphics guiGraphics, ImmutableRect2i area, int padding, ITypedIngredient<T> typedIngredient) {
        IEditModeConfig editModeConfig = Internal.getJeiRuntime().getEditModeConfig();
        if (editModeConfig.isIngredientHiddenUsingConfigFile(typedIngredient)) {
            guiGraphics.m_285944_(RenderType.m_286086_(), area.getX() + padding, area.getY() + padding, area.getX() + 16 + padding, area.getY() + 16 + padding, -65536);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, IngredientGridTooltipHelper tooltipHelper, IElement<T> element) {
        IIngredientManager ingredientManager = Internal.getJeiRuntime().getIngredientManager();
        ITypedIngredient<T> typedIngredient = element.getTypedIngredient();
        IIngredientType<T> ingredientType = typedIngredient.getType();
        IIngredientRenderer<T> ingredientRenderer = ingredientManager.getIngredientRenderer(ingredientType);
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        JeiTooltip tooltip = new JeiTooltip();
        element.getTooltip(tooltip, tooltipHelper, ingredientRenderer, ingredientHelper);
        tooltip.draw(guiGraphics, mouseX, mouseY, typedIngredient, ingredientRenderer, ingredientManager);
    }
}

