/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio;

import com.almostreliable.kubeio.enderio.EnderIOIntegration;
import com.almostreliable.kubeio.kube.KubePlugin;
import com.almostreliable.kubeio.kube.event.ConduitRegistryEvent;
import com.almostreliable.kubeio.util.SmeltingFilterSynchronizer;
import com.enderio.api.integration.Integration;
import com.enderio.api.integration.IntegrationManager;
import com.enderio.base.common.init.EIOCreativeTabs;
import com.mojang.logging.LogUtils;
import dev.latvian.mods.kubejs.event.EventJS;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.slf4j.Logger;

@Mod(value="kubejs_enderio")
public final class ModInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModInitializer() {
        LOGGER.info("Loading EnderIO integration for KubeJS");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(ModInitializer::onRegistration);
        modEventBus.addListener(ModInitializer::onTabContents);
        IntegrationManager.addIntegration((Integration)new EnderIOIntegration());
    }

    public static ResourceLocation getRl(String path) {
        return new ResourceLocation("kubejs_enderio", path);
    }

    private static void onRegistration(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256954_)) {
            ForgeRegistries.RECIPE_TYPES.register(SmeltingFilterSynchronizer.ID, SmeltingFilterSynchronizer.TYPE);
        }
        if (event.getRegistryKey().equals((Object)Registries.f_256764_)) {
            ForgeRegistries.RECIPE_SERIALIZERS.register(SmeltingFilterSynchronizer.ID, SmeltingFilterSynchronizer.SERIALIZER);
        }
        if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
            KubePlugin.Events.CONDUIT_REGISTRY.post((EventJS)new ConduitRegistryEvent());
        }
    }

    private static void onTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() != EIOCreativeTabs.CONDUITS) {
            return;
        }
        ConduitRegistryEvent.CONDUITS.stream().sorted((one, two) -> one.transferRate() - two.transferRate()).forEach(entry -> event.m_246326_((ItemLike)entry.item()));
    }
}

