/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.enderio.conduit;

import com.almostreliable.kubeio.enderio.conduit.CustomEnergyConduitData;
import com.enderio.api.conduit.ColoredRedstoneProvider;
import com.enderio.api.conduit.ConduitGraph;
import com.enderio.api.conduit.ConduitNode;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.ticker.CapabilityAwareConduitTicker;
import com.enderio.conduits.common.tag.ConduitTags;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;

public class CustomEnergyConduitTicker
extends CapabilityAwareConduitTicker<CustomEnergyConduitData, IEnergyStorage> {
    private final int transferRate;

    public CustomEnergyConduitTicker(int transferRate) {
        this.transferRate = transferRate;
    }

    public void tickGraph(ServerLevel level, ConduitType<CustomEnergyConduitData> type, List<ConduitNode<CustomEnergyConduitData>> loadedNodes, ConduitGraph<CustomEnergyConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        super.tickGraph(level, type, loadedNodes, graph, coloredRedstoneProvider);
        for (ConduitNode<CustomEnergyConduitData> node : loadedNodes) {
            CustomEnergyConduitData energyConduitData = (CustomEnergyConduitData)node.getConduitData();
            IEnergyStorage energy = (IEnergyStorage)energyConduitData.getSelfCap().resolve().orElseThrow();
            if (energy.getEnergyStored() == 0) continue;
            for (ConduitNode<CustomEnergyConduitData> otherNode : loadedNodes) {
                for (Direction dir : Direction.values()) {
                    Optional capability;
                    BlockEntity be;
                    if (!otherNode.getIOState(dir).map(ConduitNode.IOState::isInsert).orElse(false).booleanValue() || (be = level.m_7702_(otherNode.getPos().m_121945_(dir))) == null || !(capability = be.getCapability(ForgeCapabilities.ENERGY, dir.m_122424_()).resolve()).isPresent()) continue;
                    IEnergyStorage insert = (IEnergyStorage)capability.get();
                    this.extractEnergy(energy, List.of(insert), 0, i -> {});
                }
            }
        }
    }

    public void tickCapabilityGraph(ServerLevel level, ConduitType<CustomEnergyConduitData> type, List<CapabilityAwareConduitTicker.CapabilityConnection> inserts, List<CapabilityAwareConduitTicker.CapabilityConnection> extracts, ConduitGraph<CustomEnergyConduitData> graph, ColoredRedstoneProvider coloredRedstoneProvider) {
        for (CapabilityAwareConduitTicker.CapabilityConnection extract : extracts) {
            IEnergyStorage extractHandler = (IEnergyStorage)extract.capability;
            CustomEnergyConduitData.EnergySidedData sidedExtractData = ((CustomEnergyConduitData)((CustomEnergyConduitData)extract.data).castTo(CustomEnergyConduitData.class)).compute(extract.direction);
            this.extractEnergy(extractHandler, inserts.stream().map(con -> (IEnergyStorage)con.capability).toList(), sidedExtractData.rotatingIndex, i -> {
                sidedExtractData.rotatingIndex = i;
            });
        }
    }

    private void extractEnergy(IEnergyStorage extractHandler, List<IEnergyStorage> inserts, int startingIndex, Consumer<Integer> rotationIndexSetter) {
        int availableForExtraction = extractHandler.extractEnergy(this.transferRate, true);
        if (availableForExtraction <= 0) {
            return;
        }
        if (inserts.size() <= startingIndex) {
            startingIndex = 0;
            rotationIndexSetter.accept(0);
        }
        for (int j = startingIndex; j < startingIndex + inserts.size(); ++j) {
            int insertIndex = j % inserts.size();
            IEnergyStorage insert = inserts.get(insertIndex);
            int inserted = insert.receiveEnergy(availableForExtraction, false);
            extractHandler.extractEnergy(inserted, false);
            if (inserted == availableForExtraction) {
                rotationIndexSetter.accept(startingIndex + insertIndex + 1);
                return;
            }
            availableForExtraction -= inserted;
        }
    }

    public int getTickRate() {
        return 1;
    }

    public Capability<IEnergyStorage> getCapability() {
        return ForgeCapabilities.ENERGY;
    }

    public boolean canConnectTo(Level level, BlockPos conduitPos, Direction direction) {
        return super.canConnectTo(level, conduitPos, direction) && !level.m_8055_(conduitPos.m_121945_(direction)).m_204336_(ConduitTags.Blocks.ENERGY_CABLE);
    }
}

