/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.enderio.conduit;

import com.almostreliable.kubeio.enderio.conduit.CustomEnergyConduitData;
import com.almostreliable.kubeio.enderio.conduit.CustomEnergyConduitTicker;
import com.enderio.api.conduit.ConduitMenuData;
import com.enderio.api.conduit.ConduitType;
import com.enderio.api.conduit.TieredConduit;
import com.enderio.api.conduit.ticker.ConduitTicker;
import com.enderio.api.misc.RedstoneControl;
import com.enderio.conduits.common.conduit.type.energy.EnergyConduitType;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ForgeRegistries;

public class CustomEnergyConduitType
extends TieredConduit<CustomEnergyConduitData> {
    private final ResourceLocation id;
    private final ConduitTicker<CustomEnergyConduitData> ticker;

    public CustomEnergyConduitType(ResourceLocation tierName, ResourceLocation id, int transferRate) {
        super(new ResourceLocation("forge:energy"), tierName, transferRate);
        this.id = id;
        this.ticker = new CustomEnergyConduitTicker(transferRate);
    }

    public ConduitTicker<CustomEnergyConduitData> getTicker() {
        return this.ticker;
    }

    public ConduitMenuData getMenuData() {
        return ConduitMenuData.ENERGY;
    }

    public CustomEnergyConduitData createConduitData(Level level, BlockPos pos) {
        return new CustomEnergyConduitData(this.getTier());
    }

    public ConduitType.ConduitConnectionData getDefaultConnection(Level level, BlockPos pos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(pos.m_121945_(direction));
        if (blockEntity == null) {
            return super.getDefaultConnection(level, pos, direction);
        }
        LazyOptional cap = blockEntity.getCapability(ForgeCapabilities.ENERGY, direction.m_122424_());
        if (cap.isPresent()) {
            IEnergyStorage storage = (IEnergyStorage)cap.orElseThrow(() -> new RuntimeException("present capability was not found"));
            return new ConduitType.ConduitConnectionData(storage.canReceive(), storage.canExtract(), RedstoneControl.ALWAYS_ACTIVE);
        }
        return super.getDefaultConnection(level, pos, direction);
    }

    public boolean canBeReplacedBy(ConduitType<?> other) {
        return other instanceof EnergyConduitType || super.canBeReplacedBy(other);
    }

    public boolean canBeInSameBlock(ConduitType<?> other) {
        return !(other instanceof EnergyConduitType) && super.canBeInSameBlock(other);
    }

    public Item getConduitItem() {
        return Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(this.id));
    }
}

