/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.kube.recipe;

import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.filter.IDFilter;
import dev.latvian.mods.kubejs.recipe.filter.RecipeFilter;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public final class RecipesBinding {
    @HideFromJS
    public static final Set<ResourceLocation> FILTERED_SMELTING_RECIPES = new HashSet<ResourceLocation>();
    private static final List<RecipeFilter> SMELTING_RECIPE_FILTERS = new ArrayList<RecipeFilter>();

    private RecipesBinding() {
    }

    @HideFromJS
    public static void resolveRecipes(Map<ResourceLocation, RecipeJS> recipes, Function<RecipeFilter, Collection<RecipeJS>> recipeLookup) {
        FILTERED_SMELTING_RECIPES.clear();
        for (RecipeFilter filter : SMELTING_RECIPE_FILTERS) {
            if (filter instanceof IDFilter) {
                IDFilter id = (IDFilter)filter;
                RecipeJS r = recipes.get(id.id);
                if (r != null) {
                    RecipesBinding.addFilteredSmeltingRecipe(r);
                }
                return;
            }
            recipeLookup.apply(filter).forEach(RecipesBinding::addFilteredSmeltingRecipe);
        }
        SMELTING_RECIPE_FILTERS.clear();
    }

    private static void addFilteredSmeltingRecipe(RecipeJS recipe) {
        if (recipe.type.id.toString().equals("minecraft:smelting")) {
            FILTERED_SMELTING_RECIPES.add(recipe.id);
        }
    }

    public static void removeVanillaSmeltingRecipe(RecipeFilter filter) {
        SMELTING_RECIPE_FILTERS.add(filter);
    }
}

