/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.kube.schema;

import com.almostreliable.kubeio.kube.recipe.RecipeComponents;
import com.mojang.datafixers.util.Either;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.component.NumberComponent;
import dev.latvian.mods.kubejs.recipe.component.StringComponent;
import dev.latvian.mods.kubejs.recipe.schema.RecipeSchema;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.ArrayUtils;

public interface FireCraftingRecipeSchema {
    public static final RecipeKey<Either<Block, TagKey<Block>>[]> BASE_BLOCKS = RecipeComponents.BLOCK_OR_TAG_ARRAY.key("base_blocks").noBuilders();
    public static final RecipeKey<String> LOOT_TABLE = StringComponent.ID.key("loot_table").noBuilders();
    public static final RecipeKey<Integer> MAX_ITEM_DROPS = NumberComponent.INT.key("max_item_drops").preferred("maxItemDrops").optional((Object)1).alwaysWrite();
    public static final RecipeKey<String[]> DIMENSIONS = StringComponent.ID.asArray().key("dimensions").optional((Object)((String[])ArrayUtils.toArray((Object[])new String[]{"minecraft:overworld"}))).alwaysWrite();
    public static final RecipeSchema SCHEMA = new RecipeSchema(FireCraftingRecipeJS.class, FireCraftingRecipeJS::new, new RecipeKey[]{BASE_BLOCKS, LOOT_TABLE, MAX_ITEM_DROPS, DIMENSIONS});

    public static class FireCraftingRecipeJS
    extends RecipeJS {
        public FireCraftingRecipeJS dimension(ResourceLocation dimension) {
            this.setValue(DIMENSIONS, (String[])ArrayUtils.toArray((Object[])new String[]{dimension.toString()}));
            return this;
        }
    }
}

