/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.custommodel;

import com.lowdragmc.lowdraglib.client.model.custommodel.Connection;
import com.lowdragmc.lowdraglib.client.model.custommodel.ICTMPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;

public class Connections {
    protected static int[] submapOffsets = new int[]{4, 5, 1, 0};
    protected static final Connection[][] submapMap = new Connection[][]{{Connection.DOWN, Connection.LEFT, Connection.DOWN_LEFT}, {Connection.DOWN, Connection.RIGHT, Connection.DOWN_RIGHT}, {Connection.UP, Connection.RIGHT, Connection.UP_RIGHT}, {Connection.UP, Connection.LEFT, Connection.UP_LEFT}};
    private int[] submapIndices = new int[]{18, 19, 17, 16};
    private byte connections = 0;

    private Connections(Connection ... connections) {
        for (Connection connection : connections) {
            this.add(connection);
        }
    }

    public static Connections of(Connection ... connections) {
        return new Connections(connections);
    }

    public boolean contains(Connection connection) {
        return (this.connections & 1 << connection.ordinal()) > 0;
    }

    public void add(Connection connection) {
        this.connections = (byte)(this.connections | 1 << connection.ordinal());
    }

    public boolean isEmpty() {
        return this.connections == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Connections that = (Connections)o;
        return this.connections == that.connections;
    }

    public int hashCode() {
        return this.connections;
    }

    public static Connections checkConnections(BlockAndTintGetter level, BlockPos pos, @Nonnull BlockState state, @Nullable Direction side) {
        Connections connections = Connections.of(new Connection[0]);
        if (side != null) {
            pos = pos.m_7949_();
            for (Connection connection : Connection.values()) {
                BlockPos offset = connection.transform(pos, side);
                BlockState adjacent = level.m_8055_(offset);
                if (!ICTMPredicate.getPredicate(state).isConnected(level, state, pos, adjacent, offset, side)) continue;
                connections.add(connection);
            }
        }
        for (int i = 0; i < 4; ++i) {
            connections.fillSubmaps(i);
        }
        return connections;
    }

    public boolean connectedAnd(Connection ... dirs) {
        for (Connection dir : dirs) {
            if (this.contains(dir)) continue;
            return false;
        }
        return true;
    }

    public boolean connectedOr(Connection ... dirs) {
        for (Connection dir : dirs) {
            if (!this.contains(dir)) continue;
            return true;
        }
        return false;
    }

    protected void fillSubmaps(int idx) {
        Connection[] dirs = submapMap[idx];
        if (this.connectedOr(dirs[0], dirs[1])) {
            this.submapIndices[idx] = this.connectedAnd(dirs) ? submapOffsets[idx] : submapOffsets[idx] + (this.contains(dirs[0]) ? 2 : 0) + (this.contains(dirs[1]) ? 8 : 0);
        }
    }

    public int[] getSubmapIndices() {
        return this.submapIndices;
    }
}

