/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.client.model.custommodel;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Quad;
import com.lowdragmc.lowdraglib.client.bakedpipeline.Submap;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.model.custommodel.Connections;
import com.lowdragmc.lowdraglib.client.model.custommodel.LDLMetadataSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class CustomBakedModel
implements BakedModel {
    private final BakedModel parent;
    private final Table<Direction, Connections, List<BakedQuad>> sideCache;
    private final List<BakedQuad> noSideCache;

    public CustomBakedModel(BakedModel parent) {
        this.parent = parent;
        this.sideCache = Tables.newCustomTable(new EnumMap(Direction.class), HashMap::new);
        this.noSideCache = new ArrayList<BakedQuad>();
    }

    @Nonnull
    @Deprecated
    public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.parent.m_213637_(state, side, rand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<BakedQuad> getCustomQuads(BlockAndTintGetter level, BlockPos pos, @Nonnull BlockState state, @Nullable Direction side, RandomSource rand) {
        Connections connections = Connections.checkConnections(level, pos, state, side);
        if (side == null) {
            if (this.noSideCache.isEmpty()) {
                this.noSideCache.addAll(CustomBakedModel.buildCustomQuads(connections, this.parent.m_213637_(state, null, rand), 0.0f));
            }
            return this.noSideCache;
        }
        if (!this.sideCache.contains((Object)side, (Object)connections)) {
            Table<Direction, Connections, List<BakedQuad>> table = this.sideCache;
            synchronized (table) {
                this.sideCache.put((Object)side, (Object)connections, CustomBakedModel.buildCustomQuads(connections, this.parent.m_213637_(state, side, rand), 0.0f));
            }
        }
        return Objects.requireNonNull((List)this.sideCache.get((Object)side, (Object)connections));
    }

    public static List<BakedQuad> reBakeCustomQuads(List<BakedQuad> quads, BlockAndTintGetter level, BlockPos pos, @Nonnull BlockState state, @Nullable Direction side, float offset) {
        return CustomBakedModel.buildCustomQuads(Connections.checkConnections(level, pos, state, side), quads, offset);
    }

    public static List<BakedQuad> buildCustomQuads(Connections connections, List<BakedQuad> base, float offset) {
        LinkedList<BakedQuad> result = new LinkedList<BakedQuad>();
        for (BakedQuad bakedQuad : base) {
            TextureAtlasSprite connection;
            LDLMetadataSection section = LDLMetadataSection.getMetadata(bakedQuad.m_173410_());
            TextureAtlasSprite textureAtlasSprite = connection = section.connection == null ? null : ModelFactory.getBlockSprite(section.connection);
            if (connection == null) {
                result.add(CustomBakedModel.makeQuad(bakedQuad, section, offset).rebake());
                continue;
            }
            Quad quad = CustomBakedModel.makeQuad(bakedQuad, section, offset).derotate();
            Quad[] quads = quad.subdivide(4);
            int[] ctm = connections.getSubmapIndices();
            for (int j = 0; j < quads.length; ++j) {
                Quad q = quads[j];
                if (q == null) continue;
                int ctmid = q.getUvs().normalize().getQuadrant();
                quads[j] = q.grow().transformUVs(ctm[ctmid] > 15 ? bakedQuad.m_173410_() : connection, Submap.uvs[ctm[ctmid]]);
            }
            result.addAll(Arrays.stream(quads).filter(Objects::nonNull).map(Quad::rebake).toList());
        }
        return result;
    }

    protected static Quad makeQuad(BakedQuad bq, LDLMetadataSection section, float offset) {
        Quad q = Quad.from(bq, offset);
        if (section.emissive) {
            q = q.setLight(15, 15);
        }
        return q;
    }

    public boolean m_7541_() {
        return this.parent.m_7541_();
    }

    public boolean m_7539_() {
        return this.parent.m_7539_();
    }

    public boolean m_7547_() {
        return this.parent.m_7547_();
    }

    public boolean m_7521_() {
        return this.parent.m_7521_();
    }

    public TextureAtlasSprite m_6160_() {
        return this.parent.m_6160_();
    }

    public ItemTransforms m_7442_() {
        return this.parent.m_7442_();
    }

    public ItemOverrides m_7343_() {
        return this.parent.m_7343_();
    }
}

