/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.editor.data;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.MainPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.tool.WidgetToolBox;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

@LDLRegister(name="ui", group="editor.ui")
public class UIProject
implements IProject {
    public Resources resources;
    public WidgetGroup root;

    private UIProject() {
    }

    public UIProject(Resources resources, WidgetGroup root) {
        this.resources = resources;
        this.root = root;
    }

    public UIProject(CompoundTag tag) {
        this.deserializeNBT(tag);
    }

    @Override
    public UIProject newEmptyProject() {
        return new UIProject(Resources.defaultResource(), (WidgetGroup)new WidgetGroup(30, 30, 200, 200).setBackground(ResourceBorderTexture.BORDERED_BACKGROUND));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("resources", (Tag)this.resources.serializeNBT());
        tag.m_128365_("root", (Tag)IConfigurableWidget.serializeNBT((IConfigurableWidget)this.root, this.resources, true));
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag tag) {
        this.resources = this.loadResources(tag.m_128469_("resources"));
        this.root = new WidgetGroup();
        IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.root, tag.m_128469_("root"), this.resources, true);
    }

    @Override
    public Resources getResources() {
        return this.resources;
    }

    @Override
    public void onLoad(Editor editor) {
        IProject.super.onLoad(editor);
        editor.getTabPages().addTab("Main", (WidgetGroup)new MainPanel(editor, this.root));
        for (WidgetToolBox.Default tab : WidgetToolBox.Default.TABS) {
            editor.getToolPanel().addNewToolBox("ldlib.gui.editor.group." + tab.groupName, tab.icon, tab::createToolBox);
        }
    }
}

