/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes;

import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortBehavior;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.CustomPortInput;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortData;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.PortEdge;
import com.lowdragmc.lowdraglib.utils.TypeAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class ListMergeNode<T>
extends BaseNode {
    @InputPort
    public List<T> inputs = new ArrayList<T>();
    @OutputPort
    public T out;

    public abstract Class<T> type();

    public abstract T defaultValue();

    public abstract T merge(T var1, T var2);

    @Override
    public void process() {
        this.out = this.defaultValue();
        if (this.inputs != null) {
            this.out = this.inputs.stream().reduce(this.out, this::merge);
        }
    }

    @CustomPortBehavior(field="inputs")
    public List<PortData> inputPortBehavior(List<PortEdge> edges) {
        ArrayList<PortData> ports = new ArrayList<PortData>();
        for (int i = 0; i < edges.size() + 1; ++i) {
            String identifier = String.valueOf(i);
            if (i < edges.size()) {
                PortEdge edge = edges.get(i);
                edge.inputPortIdentifier = identifier;
            }
            ports.add(new PortData().displayName("in " + i).identifier(identifier).displayType(this.type()));
        }
        if (this.inputs == null) {
            this.inputs = new ArrayList<T>();
        }
        this.inputs.clear();
        while (this.inputs.size() + 1 < ports.size()) {
            this.inputs.add(this.defaultValue());
        }
        return ports;
    }

    @CustomPortBehavior(field="out")
    public List<PortData> outputPortBehavior(List<PortEdge> edges) {
        return List.of(new PortData().displayName("out").identifier("out").acceptMultipleEdges(true).displayType(this.type()));
    }

    @CustomPortInput(field="inputs")
    public void pullInputs(List<PortEdge> inputEdges, NodePort inputPort) {
        if (inputEdges.isEmpty()) {
            return;
        }
        Object value = this.defaultValue();
        for (PortEdge inputEdge : inputEdges) {
            Class<T> type;
            Class<?> edgeType = inputEdge.passThroughBuffer.getClass();
            if (edgeType == (type = this.type())) {
                value = this.merge(value, inputEdge.passThroughBuffer);
                continue;
            }
            if (!TypeAdapter.areConvertable(edgeType, type)) continue;
            value = this.merge(value, TypeAdapter.convert(inputEdge.passThroughBuffer, this.type()));
        }
        int index = inputPort.owner.getInputPorts().indexOf(inputPort);
        while (this.inputs.size() <= index) {
            this.inputs.add(value);
        }
        this.inputs.set(index, value);
    }

    @CustomPortInput(field="out")
    public void pushOutputs(List<PortEdge> outputEdges, NodePort inputPort) {
        for (PortEdge edge : outputEdges) {
            edge.passThroughBuffer = this.out;
        }
    }
}

