/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.value;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;

@LDLRegister(name="number", group="graph_processor.node.value")
public class NumberNode
extends BaseNode {
    @InputPort
    public Object in;
    @OutputPort
    public float out;
    @Configurable(showName=false)
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38}, wheel=1.0)
    @DefaultValue(numberValue={0.0})
    public float internalValue = 0.0f;

    @Override
    public void process() {
        if (this.in == null) {
            this.out = this.internalValue;
            return;
        }
        Object object = this.in;
        if (object instanceof Number) {
            Number number = (Number)object;
            this.out = number.floatValue();
        } else {
            object = this.in;
            if (object instanceof Boolean) {
                Boolean bool = (Boolean)object;
                this.out = bool != false ? 1.0f : 0.0f;
            } else {
                try {
                    this.out = Float.parseFloat(this.in.toString());
                }
                catch (NumberFormatException e) {
                    this.out = 0.0f;
                }
            }
        }
        this.internalValue = this.out;
    }

    @Override
    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("in") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

