/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.graphprocessor.processor;

import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseGraph;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ParameterNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.ITriggerableNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.StartNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.logic.BreakNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.logic.ForLoopNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.logic.LoopStartNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.processor.GraphProcessor;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;

public class TriggerProcessor
extends GraphProcessor {
    protected List<StartNode> startNodeList = Collections.emptyList();
    protected Map<BaseNode, List<BaseNode>> nonConditionalDependenciesCache = new HashMap<BaseNode, List<BaseNode>>();

    public TriggerProcessor(BaseGraph graph) {
        super(graph);
    }

    @Override
    public void updateComputeOrder() {
        this.startNodeList = this.graph.nodes.stream().filter(StartNode.class::isInstance).map(StartNode.class::cast).toList();
        if (this.startNodeList.isEmpty()) {
            super.updateComputeOrder();
        } else {
            this.nonConditionalDependenciesCache.clear();
        }
    }

    @Override
    @NotNull
    public Iterator<BaseNode> iterator() {
        this.graph.resetNodes();
        if (this.startNodeList.isEmpty()) {
            return super.iterator();
        }
        return new InternalIterator();
    }

    private List<BaseNode> gatherNonConditionalDependencies(BaseNode node) {
        if (this.nonConditionalDependenciesCache.containsKey(node)) {
            return this.nonConditionalDependenciesCache.get(node);
        }
        ArrayList<BaseNode> nodes = new ArrayList<BaseNode>();
        Stack<BaseNode> dependencies = new Stack<BaseNode>();
        dependencies.push(node);
        while (!dependencies.isEmpty()) {
            BaseNode dependency = (BaseNode)dependencies.pop();
            dependency.getInputNodes().stream().filter(n -> !(n instanceof ITriggerableNode)).forEach(dependencies::push);
            if (dependency == node) continue;
            nodes.add(dependency);
        }
        this.nonConditionalDependenciesCache.put(node, nodes);
        return nodes;
    }

    private class InternalIterator
    implements Iterator<BaseNode> {
        private final Stack<Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>> nodeToExecute = new Stack();
        private final HashSet<ITriggerableNode> nodeDependenciesGathered = new HashSet();

        private InternalIterator() {
            TriggerProcessor.this.graph.nodes.stream().filter(n -> {
                if (!(n instanceof ParameterNode)) return false;
                ParameterNode parameterNode = (ParameterNode)n;
                if (parameterNode.parameter == null) return false;
                if (parameterNode.parameter.getAccessor() != ExposedParameter.ParameterAccessor.Set) return false;
                return true;
            }).forEach(n -> {
                this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.left((Object)n));
                for (BaseNode node : TriggerProcessor.this.gatherNonConditionalDependencies((BaseNode)n)) {
                    this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.left((Object)node));
                }
            });
            TriggerProcessor.this.startNodeList.stream().sorted((n1, n2) -> n2.getComputeOrder() - n1.getComputeOrder()).forEach(n -> this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)n, null))));
        }

        @Override
        public boolean hasNext() {
            return !this.nodeToExecute.isEmpty();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public BaseNode next() {
            Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>> either;
            block0: while (true) {
                if (this.nodeToExecute.isEmpty()) {
                    return null;
                }
                either = this.nodeToExecute.pop();
                if (either.right().isPresent()) {
                    ITriggerableNode triggerNode = (ITriggerableNode)((Pair)either.right().get()).left();
                    ITriggerableNode triggerSource = (ITriggerableNode)((Pair)either.right().get()).right();
                    if (this.nodeDependenciesGathered.contains(triggerNode)) {
                        block15: {
                            if (triggerNode instanceof LoopStartNode) continue;
                            if (triggerNode instanceof BreakNode) {
                                Object object;
                                while (this.nodeToExecute.peek().right().isEmpty() || !(((Pair)this.nodeToExecute.peek().right().get()).left() instanceof LoopStartNode)) {
                                    this.nodeToExecute.pop();
                                }
                                if (this.nodeToExecute.peek().right().isEmpty() && ((Pair)this.nodeToExecute.peek().right().get()).left() instanceof LoopStartNode && (object = ((Pair)this.nodeToExecute.peek().right().get()).right()) instanceof ForLoopNode) {
                                    ForLoopNode forLoopNode = (ForLoopNode)object;
                                    forLoopNode.resetNode();
                                }
                                this.nodeToExecute.pop();
                            } else {
                                if (triggerNode instanceof ForLoopNode) {
                                    ForLoopNode forLoopNode = (ForLoopNode)triggerNode;
                                    if (forLoopNode.isLooping) {
                                        triggerNode.onTrigger(triggerSource);
                                        if (forLoopNode.index < forLoopNode.end - 1) {
                                            return triggerNode.self();
                                        }
                                        forLoopNode.isLooping = false;
                                        break block15;
                                    } else {
                                        forLoopNode.isLooping = true;
                                        forLoopNode.index = forLoopNode.start - 1;
                                        forLoopNode.getNextTriggerNodes().stream().sorted((n1, n2) -> n2.getComputeOrder() - n1.getComputeOrder()).forEach(n -> this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)n, (Object)triggerNode))));
                                        this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)new LoopStartNode(), (Object)forLoopNode)));
                                        int i = forLoopNode.start;
                                        while (true) {
                                            if (i >= forLoopNode.end) {
                                                return triggerNode.self();
                                            }
                                            forLoopNode.getExecutedNodesLoopBody().stream().sorted((n1, n2) -> n2.getComputeOrder() - n1.getComputeOrder()).forEach(n -> this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)n, (Object)triggerNode))));
                                            this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)forLoopNode, null)));
                                            ++i;
                                        }
                                    }
                                }
                                triggerNode.onTrigger(triggerSource);
                                triggerNode.getNextTriggerNodes().stream().sorted((n1, n2) -> n2.getComputeOrder() - n1.getComputeOrder()).forEach(n -> this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.right((Object)Pair.of((Object)n, (Object)triggerNode))));
                            }
                        }
                        this.nodeDependenciesGathered.remove(triggerNode);
                        return triggerNode.self();
                    }
                    this.nodeToExecute.push(either);
                    this.nodeDependenciesGathered.add(triggerNode);
                    Iterator<BaseNode> iterator = TriggerProcessor.this.gatherNonConditionalDependencies(triggerNode.self()).iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block0;
                        BaseNode nonConditionalNode = iterator.next();
                        this.nodeToExecute.push((Either<BaseNode, Pair<ITriggerableNode, ITriggerableNode>>)Either.left((Object)nonConditionalNode));
                    }
                }
                if (either.left().isPresent()) break;
            }
            BaseNode node = (BaseNode)either.left().get();
            node.onProcess();
            return node;
        }
    }
}

