/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.util;

import com.lowdragmc.lowdraglib.core.mixins.accessor.MouseHandlerAccessor;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClickData {
    public final int button;
    public final boolean isShiftClick;
    public final boolean isCtrlClick;
    public final boolean isRemote;

    private ClickData(int button, boolean isShiftClick, boolean isCtrlClick, boolean isRemote) {
        this.button = button;
        this.isShiftClick = isShiftClick;
        this.isCtrlClick = isCtrlClick;
        this.isRemote = isRemote;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ClickData() {
        int n;
        MouseHandler mouseHelper = Minecraft.m_91087_().f_91067_;
        long id = Minecraft.m_91087_().m_91268_().m_85439_();
        if (mouseHelper instanceof MouseHandlerAccessor) {
            MouseHandlerAccessor accessor = (MouseHandlerAccessor)mouseHelper;
            n = accessor.getActiveButton();
        } else {
            n = -1;
        }
        this.button = n;
        this.isShiftClick = InputConstants.m_84830_((long)id, (int)340) || InputConstants.m_84830_((long)id, (int)344);
        this.isCtrlClick = InputConstants.m_84830_((long)id, (int)341) || InputConstants.m_84830_((long)id, (int)345);
        this.isRemote = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130130_(this.button);
        buf.writeBoolean(this.isShiftClick);
        buf.writeBoolean(this.isCtrlClick);
    }

    public static ClickData readFromBuf(FriendlyByteBuf buf) {
        int button = buf.m_130242_();
        boolean shiftClick = buf.readBoolean();
        boolean ctrlClick = buf.readBoolean();
        return new ClickData(button, shiftClick, ctrlClick, false);
    }
}

