/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.util;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.client.shader.Shaders;
import com.lowdragmc.lowdraglib.client.shader.management.ShaderProgram;
import com.lowdragmc.lowdraglib.client.shader.uniform.UniformCache;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.util.forge.DrawerHelperImpl;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Rect;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

@OnlyIn(value=Dist.CLIENT)
public class DrawerHelper {
    public static ShaderProgram ROUND;
    public static ShaderProgram PANEL_BG;
    public static ShaderProgram ROUND_BOX;
    public static ShaderProgram PROGRESS_ROUND_BOX;
    public static ShaderProgram FRAME_ROUND_BOX;
    public static ShaderProgram ROUND_LINE;

    public static void init() {
        ROUND = (ShaderProgram)Util.m_137469_((Object)new ShaderProgram(), program -> program.attach(Shaders.ROUND_F).attach(Shaders.SCREEN_V));
        PANEL_BG = (ShaderProgram)Util.m_137469_((Object)new ShaderProgram(), program -> program.attach(Shaders.PANEL_BG_F).attach(Shaders.SCREEN_V));
        ROUND_BOX = (ShaderProgram)Util.m_137469_((Object)new ShaderProgram(), program -> program.attach(Shaders.ROUND_BOX_F).attach(Shaders.SCREEN_V));
        PROGRESS_ROUND_BOX = (ShaderProgram)Util.m_137469_((Object)new ShaderProgram(), program -> program.attach(Shaders.PROGRESS_ROUND_BOX_F).attach(Shaders.SCREEN_V));
        FRAME_ROUND_BOX = (ShaderProgram)Util.m_137469_((Object)new ShaderProgram(), program -> program.attach(Shaders.FRAME_ROUND_BOX_F).attach(Shaders.SCREEN_V));
        ROUND_LINE = (ShaderProgram)Util.m_137469_((Object)new ShaderProgram(), program -> program.attach(Shaders.ROUND_LINE_F).attach(Shaders.SCREEN_V));
    }

    public static void drawFluidTexture(@Nonnull GuiGraphics graphics, float xCoord, float yCoord, TextureAtlasSprite textureSprite, int maskTop, int maskRight, float zLevel, int fluidColor) {
        float uMin = textureSprite.m_118409_();
        float uMax = textureSprite.m_118410_();
        float vMin = textureSprite.m_118411_();
        float vMax = textureSprite.m_118412_();
        uMax -= (float)maskRight / 16.0f * (uMax - uMin);
        vMax -= (float)maskTop / 16.0f * (vMax - vMin);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172820_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(mat, xCoord, yCoord + 16.0f, zLevel).m_7421_(uMin, vMax).m_193479_(fluidColor).m_5752_();
        buffer.m_252986_(mat, xCoord + 16.0f - (float)maskRight, yCoord + 16.0f, zLevel).m_7421_(uMax, vMax).m_193479_(fluidColor).m_5752_();
        buffer.m_252986_(mat, xCoord + 16.0f - (float)maskRight, yCoord + (float)maskTop, zLevel).m_7421_(uMax, vMin).m_193479_(fluidColor).m_5752_();
        buffer.m_252986_(mat, xCoord, yCoord + (float)maskTop, zLevel).m_7421_(uMin, vMin).m_193479_(fluidColor).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    public static void drawFluidForGui(@Nonnull GuiGraphics graphics, FluidStack contents, long tankCapacity, int startX, int startY, int widthT, int heightT) {
        ResourceLocation LOCATION_BLOCKS_TEXTURE = InventoryMenu.f_39692_;
        TextureAtlasSprite fluidStillSprite = FluidHelper.getStillTexture(contents);
        if (fluidStillSprite == null) {
            fluidStillSprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
            if (Platform.isDevEnv()) {
                LDLib.LOGGER.error("Missing fluid texture for fluid: " + contents.getDisplayName().getString());
            }
        }
        int fluidColor = FluidHelper.getColor(contents) | 0xFF000000;
        int scaledAmount = (int)(contents.getAmount() * (long)heightT / tankCapacity);
        if (contents.getAmount() > 0L && scaledAmount < 1) {
            scaledAmount = 1;
        }
        if (scaledAmount > heightT || contents.getAmount() == tankCapacity) {
            scaledAmount = heightT;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LOCATION_BLOCKS_TEXTURE);
        int xTileCount = widthT / 16;
        int xRemainder = widthT - xTileCount * 16;
        int yTileCount = scaledAmount / 16;
        int yRemainder = scaledAmount - yTileCount * 16;
        int yStart = startY + heightT;
        for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int width = xTile == xTileCount ? xRemainder : 16;
                int height = yTile == yTileCount ? yRemainder : 16;
                int x = startX + xTile * 16;
                int y = yStart - (yTile + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                DrawerHelper.drawFluidTexture(graphics, x, y, fluidStillSprite, maskTop, maskRight, 0.0f, fluidColor);
            }
        }
        RenderSystem.enableBlend();
    }

    public static void drawBorder(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int color, int border) {
        graphics.m_286007_(() -> {
            DrawerHelper.drawSolidRect(graphics, x - border, y - border, width + 2 * border, border, color);
            DrawerHelper.drawSolidRect(graphics, x - border, y + height, width + 2 * border, border, color);
            DrawerHelper.drawSolidRect(graphics, x - border, y, border, height, color);
            DrawerHelper.drawSolidRect(graphics, x + width, y, border, height, color);
        });
    }

    public static void drawStringSized(@Nonnull GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, float scale, boolean center) {
        graphics.m_280168_().m_85836_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        double scaledTextWidth = center ? (double)((float)fontRenderer.m_92895_(text) * scale) : 0.0;
        graphics.m_280168_().m_85837_((double)x - scaledTextWidth / 2.0, (double)y, 0.0);
        graphics.m_280168_().m_85841_(scale, scale, scale);
        graphics.m_280056_(fontRenderer, text, 0, 0, color, dropShadow);
        graphics.m_280168_().m_85849_();
    }

    public static void drawStringFixedCorner(@Nonnull GuiGraphics graphics, String text, float x, float y, int color, boolean dropShadow, float scale) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float scaledWidth = (float)fontRenderer.m_92895_(text) * scale;
        Objects.requireNonNull(fontRenderer);
        float scaledHeight = 9.0f * scale;
        DrawerHelper.drawStringSized(graphics, text, x - scaledWidth, y - scaledHeight, color, dropShadow, scale, false);
    }

    public static void drawText(@Nonnull GuiGraphics graphics, String text, float x, float y, float scale, int color) {
        DrawerHelper.drawText(graphics, text, x, y, scale, color, false);
    }

    public static void drawText(@Nonnull GuiGraphics graphics, String text, float x, float y, float scale, int color, boolean shadow) {
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        RenderSystem.disableBlend();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(scale, scale, 0.0f);
        float sf = 1.0f / scale;
        graphics.m_280056_(fontRenderer, text, (int)(x * sf), (int)(y * sf), color, shadow);
        graphics.m_280168_().m_85849_();
        RenderSystem.enableBlend();
    }

    public static void drawItemStack(@Nonnull GuiGraphics graphics, ItemStack itemStack, int x, int y, int color, @Nullable String altTxt) {
        float a = ColorUtils.alpha(color);
        float r = ColorUtils.red(color);
        float g = ColorUtils.green(color);
        float b = ColorUtils.blue(color);
        RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Minecraft mc = Minecraft.m_91087_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 232.0f);
        graphics.m_280480_(itemStack, x, y);
        graphics.m_280302_(mc.f_91062_, itemStack, x, y, altTxt);
        graphics.m_280168_().m_85849_();
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
    }

    public static List<Component> getItemToolTip(ItemStack itemStack) {
        Minecraft mc = Minecraft.m_91087_();
        return Screen.m_280152_((Minecraft)mc, (ItemStack)itemStack);
    }

    public static void drawSolidRect(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int color) {
        graphics.m_280509_(x, y, x + width, y + height, color);
        RenderSystem.enableBlend();
    }

    public static void drawSolidRect(@Nonnull GuiGraphics graphics, Rect rect, int color) {
        DrawerHelper.drawSolidRect(graphics, rect.left, rect.up, rect.right, rect.down, color);
    }

    public static void drawRectShadow(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int distance) {
        DrawerHelper.drawGradientRect(graphics, x + distance, y + height, width - distance, distance, 0x4F000000, 0, false);
        DrawerHelper.drawGradientRect(graphics, x + width, y + distance, distance, height - distance, 0x4F000000, 0, true);
        float startAlpha = 0.30980393f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(mat, (float)(x += width), (float)(y += height), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)x, (float)(y + distance), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(mat, (float)(x + distance), (float)(y + distance), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(mat, (float)x, (float)y, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, startAlpha).m_5752_();
        buffer.m_252986_(mat, (float)(x + distance), (float)(y + distance), 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        buffer.m_252986_(mat, (float)(x + distance), (float)y, 0.0f).m_6122_(0, 0, 0, 0).m_5752_();
        tesselator.m_85914_();
    }

    public static void drawGradientRect(@Nonnull GuiGraphics graphics, int x, int y, int width, int height, int startColor, int endColor) {
        DrawerHelper.drawGradientRect(graphics, x, y, width, height, startColor, endColor, false);
    }

    public static void drawGradientRect(@Nonnull GuiGraphics graphics, float x, float y, float width, float height, int startColor, int endColor, boolean horizontal) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        if (horizontal) {
            buffer.m_252986_(mat, x + width, y, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            buffer.m_252986_(mat, x, y, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, x, y + height, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, x + width, y + height, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            tesselator.m_85914_();
        } else {
            buffer.m_252986_(mat, x + width, y, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, x, y, 0.0f).m_85950_(startRed, startGreen, startBlue, startAlpha).m_5752_();
            buffer.m_252986_(mat, x, y + height, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            buffer.m_252986_(mat, x + width, y + height, 0.0f).m_85950_(endRed, endGreen, endBlue, endAlpha).m_5752_();
            tesselator.m_85914_();
        }
    }

    public static void drawLines(@Nonnull GuiGraphics graphics, List<Vec2> Vec2s, int startColor, int endColor, float width) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bufferbuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        RenderBufferUtils.drawColorLines(graphics.m_280168_(), (VertexConsumer)bufferbuilder, Vec2s, startColor, endColor, width);
        tesselator.m_85914_();
        RenderSystem.defaultBlendFunc();
    }

    public static void drawTextureRect(@Nonnull GuiGraphics graphics, float x, float y, float width, float height) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        Matrix4f mat = graphics.m_280168_().m_85850_().m_252922_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_252986_(mat, x, y + height, 0.0f).m_7421_(0.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, x + width, y + height, 0.0f).m_7421_(1.0f, 0.0f).m_5752_();
        buffer.m_252986_(mat, x + width, y, 0.0f).m_7421_(1.0f, 1.0f).m_5752_();
        buffer.m_252986_(mat, x, y, 0.0f).m_7421_(0.0f, 1.0f).m_5752_();
        tesselator.m_85914_();
    }

    public static void updateScreenVshUniform(@Nonnull GuiGraphics graphics, UniformCache uniform) {
        Window window = Minecraft.m_91087_().m_91268_();
        uniform.glUniform1F("GuiScale", (float)window.m_85449_());
        uniform.glUniform2F("ScreenSize", window.m_85441_(), window.m_85442_());
        uniform.glUniformMatrix4F("PoseStack", graphics.m_280168_().m_85850_().m_252922_());
        uniform.glUniformMatrix4F("ProjMat", RenderSystem.getProjectionMatrix());
    }

    public static void drawRound(@Nonnull GuiGraphics graphics, int color, float radius, Position centerPos) {
        ROUND.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("StepLength", 1.0f);
            uniform.glUniform1F("Radius", radius);
            uniform.glUniform2F("CenterPos", centerPos.x, centerPos.y);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawPanelBg(@Nonnull GuiGraphics graphics) {
        PANEL_BG.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform1F("Density", 5.0f);
            uniform.glUniform1F("SquareSize", 0.1f);
            float bg = 0.078431375f;
            uniform.glUniform4F("BgColor", bg, bg, bg, 0.95f);
            float square = 0.15686275f;
            uniform.glUniform4F("SquareColor", square, square, square, 0.95f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawRoundBox(@Nonnull GuiGraphics graphics, Rect square, Vector4f radius, int color) {
        ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniformMatrix4F("PoseStack", new Matrix4f());
            Vector4f point1 = new Vector4f((float)square.left - 0.25f, (float)square.up - 0.25f, 0.0f, 1.0f);
            Vector4f point2 = new Vector4f((float)square.right - 0.25f, (float)square.down - 0.25f, 0.0f, 1.0f);
            Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
            point1.mul((Matrix4fc)matrix);
            point2.mul((Matrix4fc)matrix);
            Vector4f v1 = matrix.transform(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
            Vector4f v2 = matrix.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            float scale = v1.x - v2.x;
            uniform.glUniform4F("SquareVertex", point1.x, point1.y, point2.x, point2.y);
            uniform.glUniform4F("RoundRadius", radius.x() * scale, radius.y() * scale, radius.z() * scale, radius.w() * scale);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawProgressRoundBox(@Nonnull GuiGraphics graphics, Rect square, Vector4f radius, int color1, int color2, float progress) {
        PROGRESS_ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform4F("SquareVertex", square.left, square.up, square.right, square.down);
            uniform.glUniform4F("RoundRadius", radius.x(), radius.y(), radius.z(), radius.w());
            uniform.fillRGBAColor("Color1", color1);
            uniform.fillRGBAColor("Color2", color2);
            uniform.glUniform1F("Blur", 2.0f);
            uniform.glUniform1F("Progress", progress);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawFrameRoundBox(@Nonnull GuiGraphics graphics, Rect square, float thickness, Vector4f radius1, Vector4f radius2, int color) {
        FRAME_ROUND_BOX.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniformMatrix4F("PoseStack", new Matrix4f());
            Vector4f point1 = new Vector4f((float)square.left - 0.25f, (float)square.up - 0.25f, 0.0f, 1.0f);
            Vector4f point2 = new Vector4f((float)square.right - 0.25f, (float)square.down - 0.25f, 0.0f, 1.0f);
            Matrix4f matrix = graphics.m_280168_().m_85850_().m_252922_();
            point1.mul((Matrix4fc)matrix);
            point2.mul((Matrix4fc)matrix);
            Vector4f v1 = matrix.transform(new Vector4f(1.0f, 1.0f, 1.0f, 1.0f));
            Vector4f v2 = matrix.transform(new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
            float scale = v1.x - v2.x;
            uniform.glUniform4F("SquareVertex", point1.x, point1.y, point2.x, point2.y);
            uniform.glUniform4F("RoundRadius1", radius1.x() * scale, radius1.y() * scale, radius1.z() * scale, radius1.w() * scale);
            uniform.glUniform4F("RoundRadius2", radius2.x() * scale, radius2.y() * scale, radius2.z() * scale, radius2.w() * scale);
            uniform.glUniform1F("Thickness", thickness * scale);
            uniform.fillRGBAColor("Color", color);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    public static void drawRoundLine(@Nonnull GuiGraphics graphics, Position begin, Position end, int width, int color1, int color2) {
        ROUND_LINE.use(uniform -> {
            DrawerHelper.updateScreenVshUniform(graphics, uniform);
            uniform.glUniform1F("Width", width);
            uniform.glUniform2F("Point1", begin.x, begin.y);
            uniform.glUniform2F("Point2", end.x, end.y);
            uniform.fillRGBAColor("Color1", color1);
            uniform.fillRGBAColor("Color2", color2);
            uniform.glUniform1F("Blur", 2.0f);
        });
        RenderSystem.enableBlend();
        DrawerHelper.uploadScreenPosVertex();
    }

    private static void uploadScreenPosVertex() {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        builder.m_5483_(-1.0, 1.0, 0.0).m_5752_();
        builder.m_5483_(-1.0, -1.0, 0.0).m_5752_();
        builder.m_5483_(1.0, -1.0, 0.0).m_5752_();
        builder.m_5483_(1.0, 1.0, 0.0).m_5752_();
        BufferUploader.m_231209_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void drawTooltip(GuiGraphics graphics, int mouseX, int mouseY, List<Component> tooltipTexts, ItemStack tooltipStack, @Nullable TooltipComponent tooltipComponent, Font tooltipFont) {
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        DrawerHelperImpl.drawTooltip(graphics, (int)var1_1, (int)var2_2, (List<Component>)var3_3, (ItemStack)var4_4, (TooltipComponent)var5_5, (Font)var6_6);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ClientTooltipComponent getClientTooltipComponent(TooltipComponent component) {
        return DrawerHelperImpl.getClientTooltipComponent(component);
    }
}

