/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.gui.widget.custom;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Position;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;

@LDLRegister(name="player_inventory", group="widget.custom")
public class PlayerInventoryWidget
extends WidgetGroup {
    @Configurable(name="ldlib.gui.editor.name.slot_background")
    private IGuiTexture slotBackground = SlotWidget.ITEM_SLOT_TEXTURE.copy();

    public PlayerInventoryWidget() {
        super(0, 0, 172, 86);
        for (int col = 0; col < 9; ++col) {
            String id = "player_inv_" + col;
            Position pos = new Position(5 + col * 18, 63);
            SlotWidget slot = new SlotWidget();
            slot.initTemplate();
            slot.setSelfPosition(pos);
            slot.setId(id);
            this.addWidget(slot);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                String id = "player_inv_" + (col + (row + 1) * 9);
                Position pos = new Position(5 + col * 18, 5 + row * 18);
                SlotWidget slot = new SlotWidget();
                slot.initTemplate();
                slot.setSelfPosition(pos);
                slot.setId(id);
                this.addWidget(slot);
            }
        }
    }

    @Override
    public void initTemplate() {
    }

    @Override
    public void initWidget() {
        super.initWidget();
        for (int i = 0; i < this.widgets.size(); ++i) {
            Object e = this.widgets.get(i);
            if (!(e instanceof SlotWidget)) continue;
            SlotWidget slotWidget = (SlotWidget)e;
            slotWidget.setContainerSlot((Container)this.gui.entityPlayer.m_150109_(), i);
            slotWidget.setLocationInfo(true, i < 9);
            slotWidget.setBackground(this.slotBackground);
            if (LDLib.isClient() && Editor.INSTANCE != null) {
                slotWidget.setCanPutItems(false);
                slotWidget.setCanTakeItems(false);
                continue;
            }
            slotWidget.setCanPutItems(true);
            slotWidget.setCanTakeItems(true);
        }
    }

    @Deprecated
    public void setPlayer(Player entityPlayer) {
        for (int i = 0; i < this.widgets.size(); ++i) {
            Object e = this.widgets.get(i);
            if (!(e instanceof SlotWidget)) continue;
            SlotWidget slotWidget = (SlotWidget)e;
            slotWidget.setContainerSlot((Container)entityPlayer.m_150109_(), i);
            slotWidget.setLocationInfo(true, i < 9);
        }
    }

    @ConfigSetter(field="slotBackground")
    public void setSlotBackground(IGuiTexture slotBackground) {
        this.slotBackground = slotBackground;
        for (Widget widget : this.widgets) {
            if (!(widget instanceof SlotWidget)) continue;
            SlotWidget slotWidget = (SlotWidget)widget;
            slotWidget.setBackground(slotBackground);
        }
    }

    public IGuiTexture getSlotBackground() {
        return this.slotBackground;
    }
}

