/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.accessor.CustomObjectAccessor;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class IRendererAccessor
extends CustomObjectAccessor<IRenderer> {
    public IRendererAccessor() {
        super(IRenderer.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, IRenderer value) {
        if (value instanceof ISerializableRenderer) {
            ISerializableRenderer serializableRenderer = (ISerializableRenderer)value;
            return NbtTagPayload.of((Tag)ISerializableRenderer.serializeWrapper(serializableRenderer));
        }
        if (value instanceof UIResourceRenderer) {
            UIResourceRenderer renderer = (UIResourceRenderer)value;
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("_type", "ui_resource");
            tag.m_128359_("key", renderer.key);
            return NbtTagPayload.of((Tag)tag);
        }
        return NbtTagPayload.of((Tag)new CompoundTag());
    }

    @Override
    public IRenderer deserialize(AccessorOp op, ITypedPayload<?> payload) {
        NbtTagPayload nbtTagPayload;
        Object t;
        if (payload instanceof NbtTagPayload && (t = (nbtTagPayload = (NbtTagPayload)payload).getPayload()) instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)t;
            if (tag.m_128441_("_type") && tag.m_128461_("_type").equals("ui_resource")) {
                Resource<IRenderer> resource = UIResourceRenderer.getProjectResource();
                String key = tag.m_128461_("key");
                if (resource == null) {
                    return new UIResourceRenderer(key);
                }
                if (UIResourceRenderer.isProject()) {
                    return new UIResourceRenderer(resource, key);
                }
                return resource.getResourceOrDefault(key, IRenderer.EMPTY);
            }
            ISerializableRenderer renderer = ISerializableRenderer.deserializeWrapper(tag);
            if (renderer != null) {
                return renderer;
            }
        }
        return IRenderer.EMPTY;
    }
}

