/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.lowdraglib.syncdata.managed;

import com.lowdragmc.lowdraglib.syncdata.managed.IManagedVar;

public class ManagedArrayItem<T>
implements IManagedVar<T> {
    protected Object array;
    protected Class<T> type;
    protected int index;

    @Override
    public T value() {
        return (T)((Object[])this.array)[this.index];
    }

    @Override
    public void set(T value) {
        ((Object[])this.array)[this.index] = value;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public ManagedArrayItem(Object array, int index) {
        this.array = array;
        this.type = array.getClass().getComponentType();
        this.index = index;
    }

    public static <T> ManagedArrayItem<T> of(Object array, int index) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Not an array");
        }
        Class<?> type = array.getClass().getComponentType();
        if (type == Integer.TYPE) {
            return new IntArrayItem(array, index);
        }
        if (type == Long.TYPE) {
            return new LongArrayItem(array, index);
        }
        if (type == Float.TYPE) {
            return new FloatArrayItem(array, index);
        }
        if (type == Double.TYPE) {
            return new DoubleArrayItem(array, index);
        }
        if (type == Boolean.TYPE) {
            return new BooleanArrayItem(array, index);
        }
        if (type == Byte.TYPE) {
            return new ByteArrayItem(array, index);
        }
        if (type == Character.TYPE) {
            return new CharArrayItem(array, index);
        }
        if (type == Short.TYPE) {
            return new ShortArrayItem(array, index);
        }
        return new ManagedArrayItem<T>(array, index);
    }

    static class IntArrayItem
    extends ManagedArrayItem<Integer>
    implements IManagedVar.Int {
        public IntArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Integer value() {
            return this.intValue();
        }

        @Override
        public void set(Integer value) {
            this.setInt(value);
        }

        @Override
        public void setInt(int value) {
            ((int[])this.array)[this.index] = value;
        }

        @Override
        public int intValue() {
            return ((int[])this.array)[this.index];
        }
    }

    static class LongArrayItem
    extends ManagedArrayItem<Long>
    implements IManagedVar.Long {
        public LongArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Long value() {
            return this.longValue();
        }

        @Override
        public void set(Long value) {
            this.setLong(value);
        }

        @Override
        public void setLong(long value) {
            ((long[])this.array)[this.index] = value;
        }

        @Override
        public long longValue() {
            return ((long[])this.array)[this.index];
        }
    }

    static class FloatArrayItem
    extends ManagedArrayItem<Float>
    implements IManagedVar.Float {
        public FloatArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Float value() {
            return Float.valueOf(this.floatValue());
        }

        @Override
        public void set(Float value) {
            this.setFloat(value.floatValue());
        }

        @Override
        public void setFloat(float value) {
            ((float[])this.array)[this.index] = value;
        }

        @Override
        public float floatValue() {
            return ((float[])this.array)[this.index];
        }
    }

    static class DoubleArrayItem
    extends ManagedArrayItem<Double>
    implements IManagedVar.Double {
        public DoubleArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Double value() {
            return this.doubleValue();
        }

        @Override
        public void set(Double value) {
            this.setDouble(value);
        }

        @Override
        public void setDouble(double value) {
            ((double[])this.array)[this.index] = value;
        }

        @Override
        public double doubleValue() {
            return ((double[])this.array)[this.index];
        }
    }

    static class BooleanArrayItem
    extends ManagedArrayItem<Boolean>
    implements IManagedVar.Boolean {
        public BooleanArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Boolean value() {
            return this.booleanValue();
        }

        @Override
        public void set(Boolean value) {
            this.setBoolean(value);
        }

        @Override
        public void setBoolean(boolean value) {
            ((boolean[])this.array)[this.index] = value;
        }

        @Override
        public boolean booleanValue() {
            return ((boolean[])this.array)[this.index];
        }
    }

    static class ByteArrayItem
    extends ManagedArrayItem<Byte>
    implements IManagedVar.Byte {
        public ByteArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Byte value() {
            return this.byteValue();
        }

        @Override
        public void set(Byte value) {
            this.setByte(value);
        }

        @Override
        public void setByte(byte value) {
            ((byte[])this.array)[this.index] = value;
        }

        @Override
        public byte byteValue() {
            return ((byte[])this.array)[this.index];
        }
    }

    static class CharArrayItem
    extends ManagedArrayItem<Character>
    implements IManagedVar.Char {
        public CharArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Character value() {
            return Character.valueOf(this.charValue());
        }

        @Override
        public void set(Character value) {
            this.setChar(value.charValue());
        }

        @Override
        public void setChar(char value) {
            ((char[])this.array)[this.index] = value;
        }

        @Override
        public char charValue() {
            return ((char[])this.array)[this.index];
        }
    }

    static class ShortArrayItem
    extends ManagedArrayItem<Short>
    implements IManagedVar.Short {
        public ShortArrayItem(Object array, int index) {
            super(array, index);
        }

        @Override
        public Short value() {
            return this.shortValue();
        }

        @Override
        public void set(Short value) {
            this.setShort(value);
        }

        @Override
        public void setShort(short value) {
            ((short[])this.array)[this.index] = value;
        }

        @Override
        public short shortValue() {
            return ((short[])this.array)[this.index];
        }
    }
}

