/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import mcjty.lostcities.editor.EditModeData;
import mcjty.lostcities.setup.Registration;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.ComponentFactory;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.LostCityFeature;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.WorldGenLevel;

public class CommandListParts
implements Command<CommandSourceStack> {
    private static final CommandListParts CMD = new CommandListParts();

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"listparts").requires(cs -> cs.m_6761_(1))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        BlockPos start = player.m_20183_();
        ServerLevel level = (ServerLevel)player.m_9236_();
        IDimensionInfo dimInfo = ((LostCityFeature)((Object)Registration.LOSTCITY_FEATURE.get())).getDimensionInfo((WorldGenLevel)level);
        if (dimInfo == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentFactory.literal("This dimension doesn't support Lost Cities!"));
            return 0;
        }
        if (!dimInfo.getProfile().EDITMODE) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)ComponentFactory.literal("This world was not created with edit mode enabled. This command is not possible!"));
            return 0;
        }
        ChunkPos cp = new ChunkPos(start);
        List<EditModeData.PartData> data = EditModeData.getData().getPartData(new ChunkCoord((ResourceKey<Level>)level.m_46472_(), cp.f_45578_, cp.f_45579_));
        for (EditModeData.PartData pd : data) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> ComponentFactory.literal("Found '" + pd.partName() + "' at " + pd.y()), false);
        }
        return 0;
    }
}

