/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen.lost;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import mcjty.lostcities.config.LostCityProfile;
import mcjty.lostcities.varia.ChunkCoord;
import mcjty.lostcities.varia.Counter;
import mcjty.lostcities.varia.Tools;
import mcjty.lostcities.worldgen.IDimensionInfo;
import mcjty.lostcities.worldgen.lost.BuildingInfo;
import mcjty.lostcities.worldgen.lost.City;
import mcjty.lostcities.worldgen.lost.cityassets.AssetRegistries;
import mcjty.lostcities.worldgen.lost.cityassets.CityStyle;
import mcjty.lostcities.worldgen.lost.cityassets.MultiBuilding;
import mcjty.lostcities.worldgen.lost.regassets.data.MultiSettings;
import net.minecraft.world.level.CommonLevelAccessor;
import org.jetbrains.annotations.NotNull;

public class MultiChunk {
    private static final Map<ChunkCoord, MultiChunk> MULTICHUNKS = new HashMap<ChunkCoord, MultiChunk>();
    private final ChunkCoord mc;
    private final ChunkCoord topleft;
    private final int areasize;
    private final MB[][] buildingGrid;

    public static void cleanCache() {
        MULTICHUNKS.clear();
    }

    public MultiChunk(ChunkCoord mc, int areasize) {
        this.mc = mc;
        this.topleft = new ChunkCoord(mc.dimension(), mc.chunkX() * areasize, mc.chunkZ() * areasize);
        this.areasize = areasize;
        this.buildingGrid = new MB[areasize][areasize];
        for (int x = 0; x < areasize; ++x) {
            for (int z = 0; z < areasize; ++z) {
                this.buildingGrid[x][z] = null;
            }
        }
    }

    public static synchronized MultiChunk getOrCreate(IDimensionInfo provider, ChunkCoord coord) {
        int areasize = provider.getWorldStyle().getMultiSettings().areasize();
        ChunkCoord mc = MultiChunk.getMultiCoord(coord, areasize);
        return MULTICHUNKS.computeIfAbsent(mc, k -> new MultiChunk(mc, areasize).calculateBuildings(provider));
    }

    public MB getMultiBuilding(ChunkCoord coord) {
        return this.buildingGrid[coord.chunkX() - this.topleft.chunkX()][coord.chunkZ() - this.topleft.chunkZ()];
    }

    @NotNull
    private static ChunkCoord getMultiCoord(ChunkCoord coord, int areasize) {
        return new ChunkCoord(coord.dimension(), Math.floorDiv(coord.chunkX(), areasize), Math.floorDiv(coord.chunkZ(), areasize));
    }

    private MultiChunk calculateBuildings(IDimensionInfo provider) {
        int i;
        int max;
        Random rand = new Random((long)this.mc.chunkX() * 797013493L + (long)this.mc.chunkZ() * 295085213L);
        MultiSettings settings = provider.getWorldStyle().getMultiSettings();
        int min = settings.minimum();
        int cnt = min + rand.nextInt((max = settings.maximum()) - min + 1);
        if (cnt <= 0) {
            return this;
        }
        ChunkCoord topleft = new ChunkCoord(this.mc.dimension(), this.mc.chunkX() * this.areasize, this.mc.chunkZ() * this.areasize);
        Counter<CityStyle> cityStyleCounter = new Counter<CityStyle>();
        for (int x = 0; x < this.areasize; ++x) {
            for (int z = 0; z < this.areasize; ++z) {
                CityStyle cityStyle = City.getCityStyle(topleft.offset(x, z), provider, provider.getProfile());
                if (cityStyle == null) {
                    throw new RuntimeException("Cannot find city style for chunk: " + topleft.offset(x, z));
                }
                cityStyleCounter.add(cityStyle);
            }
        }
        ArrayList<String> multiBuildings = new ArrayList<String>();
        ArrayList styleList = new ArrayList(cityStyleCounter.getMap().keySet());
        ArrayList<CityStyle> styleForBuilding = new ArrayList<CityStyle>();
        for (i = 0; i < cnt; ++i) {
            CityStyle cityStyle = Tools.getRandomFromList(rand, styleList, style -> Float.valueOf(cityStyleCounter.get((CityStyle)style)));
            String multiBuilding = cityStyle.getRandomMultiBuilding(rand);
            multiBuildings.add(multiBuilding);
            styleForBuilding.add(cityStyle);
        }
        multiBuildings.sort((b1, b2) -> {
            if (b1 == null && b2 == null) {
                return 0;
            }
            if (b1 == null) {
                return 1;
            }
            if (b2 == null) {
                return -1;
            }
            MultiBuilding building1 = AssetRegistries.MULTI_BUILDINGS.get((CommonLevelAccessor)provider.getWorld(), (String)b1);
            if (building1 == null) {
                throw new RuntimeException("Cannot find multibuilding: " + b1);
            }
            MultiBuilding building2 = AssetRegistries.MULTI_BUILDINGS.get((CommonLevelAccessor)provider.getWorld(), (String)b2);
            if (building2 == null) {
                throw new RuntimeException("Cannot find multibuilding: " + b2);
            }
            return Integer.compare(building2.getDimX() + building2.getDimZ(), building1.getDimX() + building1.getDimZ());
        });
        block3: for (i = 0; i < multiBuildings.size(); ++i) {
            String multiBuilding = (String)multiBuildings.get(i);
            if (multiBuilding == null) continue;
            MultiBuilding building = AssetRegistries.MULTI_BUILDINGS.get((CommonLevelAccessor)provider.getWorld(), multiBuilding);
            if (building == null) {
                throw new RuntimeException("Cannot find multibuilding: " + multiBuilding);
            }
            int dimX = building.getDimX();
            int dimZ = building.getDimZ();
            int attempts = settings.attempts();
            for (int att = 0; att < attempts; ++att) {
                int x = rand.nextInt(this.areasize - dimX + 1);
                int z = rand.nextInt(this.areasize - dimZ + 1);
                if (!this.canPlaceBuilding(topleft, provider, provider.getProfile(), (CityStyle)styleForBuilding.get(i), building, x, z)) continue;
                this.placeBuilding(building, x, z);
                continue block3;
            }
        }
        return this;
    }

    private void dump() {
        HashMap<String, String> charMap = new HashMap<String, String>();
        String chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        System.out.println("################################");
        System.out.println("mc = " + this.mc);
        for (int z = 0; z < this.areasize; ++z) {
            for (int x = 0; x < this.areasize; ++x) {
                MB building = this.buildingGrid[x][z];
                if (building == null) {
                    System.out.print(" ");
                    continue;
                }
                String s = (String)charMap.get(building.name);
                if (s == null) {
                    s = chars.substring(0, 1);
                    chars = chars.substring(1);
                    charMap.put(building.name, s);
                }
                System.out.print(s);
            }
            System.out.println();
        }
    }

    private boolean canPlaceBuilding(ChunkCoord topleft, IDimensionInfo provider, LostCityProfile profile, CityStyle buildingCityStyle, MultiBuilding building, int x, int z) {
        int correctStyle = 0;
        for (int xx = 0; xx < building.getDimX(); ++xx) {
            for (int zz = 0; zz < building.getDimZ(); ++zz) {
                boolean result;
                if (this.buildingGrid[x + xx][z + zz] != null) {
                    return false;
                }
                ChunkCoord coord = topleft.offset(x + xx, z + zz);
                if (City.isChunkOccupied(provider, coord)) {
                    return false;
                }
                boolean bl = result = BuildingInfo.isCityRaw(coord, provider, profile) && !BuildingInfo.hasHighway(coord, provider, profile) && !BuildingInfo.hasRailwayAtSurface(coord, provider, profile);
                if (!result) {
                    return false;
                }
                CityStyle cityStyle = City.getCityStyle(coord, provider, profile);
                if (!Objects.equals(cityStyle, buildingCityStyle)) continue;
                ++correctStyle;
            }
        }
        float correctStyleFactor = provider.getWorldStyle().getMultiSettings().correctStyleFactor();
        return !((float)correctStyle < (float)(building.getDimX() * building.getDimZ()) * correctStyleFactor);
    }

    private void placeBuilding(MultiBuilding building, int x, int z) {
        for (int xx = 0; xx < building.getDimX(); ++xx) {
            for (int zz = 0; zz < building.getDimZ(); ++zz) {
                this.buildingGrid[x + xx][z + zz] = new MB(building.getName(), xx, zz);
            }
        }
    }

    record MB(String name, int offsetX, int offsetZ) {
    }
}

