/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.parts.IPartItem;
import appeng.hooks.ticking.TickHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import stone.mae2.parts.p2p.multi.MultiP2PTunnelPart;

public abstract class CapabilityMultiP2PPart<P extends CapabilityMultiP2PPart<P, A>, A>
extends MultiP2PTunnelPart<P> {
    private final Capability<A> capability;
    private boolean inBlockUpdate = false;
    private int accessDepth = 0;
    private final CapabilityGuard capabilityGuard = new CapabilityGuard();
    private final EmptyCapabilityGuard emptyCapabilityGuard = new EmptyCapabilityGuard();
    protected A inputHandler;
    protected A outputHandler;
    protected A emptyHandler;

    public CapabilityMultiP2PPart(IPartItem<?> partItem, Capability<A> capability) {
        super(partItem);
        this.capability = capability;
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 2.0f;
    }

    public final <T> LazyOptional<T> getCapability(Capability<T> capabilityClass) {
        if (capabilityClass == this.capability) {
            if (this.isOutput()) {
                return LazyOptional.of(() -> this.outputHandler).cast();
            }
            return LazyOptional.of(() -> this.inputHandler).cast();
        }
        return LazyOptional.empty();
    }

    protected final CapabilityGuard getAdjacentCapability() {
        ++this.accessDepth;
        return this.capabilityGuard;
    }

    private BlockPos getFacingPos() {
        return this.getHost().getLocation().getPos().m_121945_(this.getSide());
    }

    protected void sendBlockUpdate() {
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                this.getHost().notifyNeighborNow(this.getSide());
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    @Override
    public void onTunnelNetworkChange() {
        TickHandler.instance().addCallable((LevelAccessor)this.getLevel(), () -> {
            if (this.getMainNode().isReady()) {
                this.sendBlockUpdate();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (!this.getFacingPos().equals((Object)neighbor)) {
            return;
        }
        if (!this.inBlockUpdate) {
            this.inBlockUpdate = true;
            try {
                if (this.isOutput()) {
                    this.getInputStream().forEach(input -> input.sendBlockUpdate());
                } else {
                    this.getOutputStream().forEach(output -> output.sendBlockUpdate());
                }
            }
            finally {
                this.inBlockUpdate = false;
            }
        }
    }

    protected class CapabilityGuard
    implements AutoCloseable {
        protected CapabilityGuard() {
        }

        public A get() {
            if (CapabilityMultiP2PPart.this.accessDepth == 0) {
                throw new IllegalStateException("get was called after closing the wrapper");
            }
            if (CapabilityMultiP2PPart.this.accessDepth == 1) {
                BlockEntity self;
                BlockEntity te;
                if (CapabilityMultiP2PPart.this.isActive() && (te = (self = CapabilityMultiP2PPart.this.getBlockEntity()).m_58904_().m_7702_(CapabilityMultiP2PPart.this.getFacingPos())) != null) {
                    return te.getCapability(CapabilityMultiP2PPart.this.capability, CapabilityMultiP2PPart.this.getSide().m_122424_()).orElse(CapabilityMultiP2PPart.this.emptyHandler);
                }
                return CapabilityMultiP2PPart.this.emptyHandler;
            }
            return CapabilityMultiP2PPart.this.emptyHandler;
        }

        @Override
        public void close() {
            if (--CapabilityMultiP2PPart.this.accessDepth < 0) {
                throw new IllegalStateException("Close has been called multiple times");
            }
        }
    }

    protected class EmptyCapabilityGuard
    extends CapabilityGuard
    implements AutoCloseable {
        protected EmptyCapabilityGuard() {
        }

        @Override
        public void close() {
        }

        @Override
        public A get() {
            return CapabilityMultiP2PPart.this.emptyHandler;
        }
    }
}

