/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.features.P2PTunnelAttunement;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.util.AECableType;
import appeng.api.util.AEColor;
import appeng.client.render.cablebus.P2PTunnelFrequencyModelData;
import appeng.parts.AEBasePart;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import appeng.util.SettingsFrom;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import stone.mae2.api.features.MultiP2PTunnelAttunement;
import stone.mae2.me.service.MultiP2PService;

public abstract class MultiP2PTunnelPart<T extends MultiP2PTunnelPart<T>>
extends AEBasePart {
    private static final String CONFIG_NBT_TYPE = "p2pType";
    private static final String CONFIG_NBT_FREQ = "p2pFreq";
    private boolean output;
    private short freq;

    public MultiP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().setIdlePowerUsage((double)this.getPowerDrainPerTick());
        this.getMainNode().setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
    }

    protected float getPowerDrainPerTick() {
        return 1.0f;
    }

    public List<T> getInputs() {
        return this.getInputStream().toList();
    }

    public Stream<T> getInputStream() {
        IGrid grid;
        if (this.getMainNode().isOnline() && (grid = this.getMainNode().getGrid()) != null) {
            return ((MultiP2PService)grid.getService(MultiP2PService.class)).getInputs(this.getFrequency(), ((Object)((Object)this)).getClass());
        }
        return Stream.empty();
    }

    public List<T> getOutputs() {
        return this.getOutputStream().toList();
    }

    public Stream<T> getOutputStream() {
        IGrid grid;
        if (this.getMainNode().isOnline() && (grid = this.getMainNode().getGrid()) != null) {
            return ((MultiP2PService)grid.getService(MultiP2PService.class)).getOutputs(this.getFrequency(), ((Object)((Object)this)).getClass());
        }
        return Stream.empty();
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
        bch.addBox(3.0, 3.0, 13.0, 13.0, 13.0, 14.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
    }

    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.setOutput(data.m_128471_("output"));
        this.freq = data.m_128448_("freq");
    }

    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        data.m_128379_("output", this.isOutput());
        data.m_128376_("freq", this.getFrequency());
    }

    public boolean readFromStream(FriendlyByteBuf data) {
        boolean c = super.readFromStream(data);
        short oldf = this.freq;
        this.freq = data.readShort();
        return c || oldf != this.freq;
    }

    public void writeToStream(FriendlyByteBuf data) {
        super.writeToStream(data);
        data.writeShort((int)this.getFrequency());
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    public boolean useStandardMemoryCard() {
        return false;
    }

    public boolean onPartActivate(Player player, InteractionHand hand, Vec3 pos) {
        IPartItem singleType;
        IPartItem<? extends MultiP2PTunnelPart<?>> newType;
        Item configData;
        Item item;
        boolean settingOutput;
        ItemStack is;
        if (this.isClientSide()) {
            return true;
        }
        if (hand == InteractionHand.OFF_HAND) {
            return false;
        }
        if (player.m_21205_().m_41619_()) {
            is = player.m_21206_();
            settingOutput = false;
        } else {
            is = player.m_21205_();
            settingOutput = true;
        }
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)item;
            configData = mc.getData(is);
            IPartItem partItem = IPartItem.byId((ResourceLocation)new ResourceLocation(configData.m_128461_(CONFIG_NBT_TYPE)));
            if (partItem != null && (P2PTunnelPart.class.isAssignableFrom(partItem.getPartClass()) || MultiP2PTunnelPart.class.isAssignableFrom(partItem.getPartClass()))) {
                MultiP2PTunnelPart newBus = this;
                if (newBus.getPartItem() != partItem) {
                    newBus = this.getHost().replacePart(partItem, this.getSide(), player, hand);
                }
                if (newBus instanceof P2PTunnelPart) {
                    P2PTunnelPart newTunnel = (P2PTunnelPart)newBus;
                    newTunnel.importSettings(SettingsFrom.MEMORY_CARD, (CompoundTag)configData, player);
                } else if (newBus instanceof MultiP2PTunnelPart) {
                    MultiP2PTunnelPart newTunnel = newBus;
                    newTunnel.importSettings(SettingsFrom.MEMORY_CARD, (CompoundTag)configData, player, settingOutput);
                }
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                return true;
            }
            mc.notifyUser(player, MemoryCardMessages.INVALID_MACHINE);
            return false;
        }
        configData = P2PTunnelAttunement.getTunnelPartByTriggerItem((ItemStack)is).m_41720_();
        if (configData instanceof IPartItem && (newType = MultiP2PTunnelAttunement.getMultiPartBySinglePart(singleType = (IPartItem)configData)) != null && newType != this.getPartItem()) {
            boolean oldOutput = this.isOutput();
            short myFreq = this.getFrequency();
            MultiP2PTunnelPart tunnel = (MultiP2PTunnelPart)this.getHost().replacePart(newType, this.getSide(), player, hand);
            tunnel.setOutput(oldOutput);
            tunnel.onTunnelNetworkChange();
            tunnel.getMainNode().ifPresent(grid -> ((MultiP2PService)grid.getService(MultiP2PService.class)).updateFreq(tunnel, myFreq));
            Platform.notifyBlocksOfNeighbors((Level)this.getLevel(), (BlockPos)this.getBlockEntity().m_58899_());
            return true;
        }
        return false;
    }

    public boolean onPartShiftActivate(Player player, InteractionHand hand, Vec3 pos) {
        Item item;
        ItemStack is = player.m_150109_().m_36056_();
        if (!is.m_41619_() && (item = is.m_41720_()) instanceof IMemoryCard) {
            IMemoryCard mc = (IMemoryCard)item;
            if (this.isClientSide()) {
                return true;
            }
            CompoundTag data = mc.getData(is);
            short storedFrequency = data.m_128448_("freq");
            short newFreq = this.getFrequency();
            boolean wasOutput = this.isOutput();
            this.setOutput(false);
            boolean needsNewFrequency = wasOutput || this.getFrequency() == 0 || storedFrequency == newFreq;
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                MultiP2PService p2p = (MultiP2PService)grid.getService(MultiP2PService.class);
                if (needsNewFrequency) {
                    newFreq = p2p.newFrequency();
                }
                p2p.updateFreq(this, newFreq);
            }
            this.onTunnelConfigChange();
            String type = this.getPartItem().m_5456_().m_5524_();
            this.exportSettings(SettingsFrom.MEMORY_CARD, data);
            mc.setMemoryCardContents(is, type, data);
            if (needsNewFrequency) {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_RESET);
            } else {
                mc.notifyUser(player, MemoryCardMessages.SETTINGS_SAVED);
            }
            return true;
        }
        return false;
    }

    public void importSettings(SettingsFrom mode, CompoundTag input, @Nullable Player player, boolean settingOutput) {
        short freq;
        super.importSettings(mode, input, player);
        if (input.m_128425_(CONFIG_NBT_FREQ, 2) && (freq = input.m_128448_(CONFIG_NBT_FREQ)) != this.freq) {
            this.setOutput(settingOutput);
            IGrid grid = this.getMainNode().getGrid();
            if (grid != null) {
                ((MultiP2PService)grid.getService(MultiP2PService.class)).updateFreq(this, freq);
            } else {
                this.setFrequency(freq);
                this.onTunnelNetworkChange();
            }
        }
    }

    public void exportSettings(SettingsFrom mode, CompoundTag output) {
        super.exportSettings(mode, output);
        if (mode == SettingsFrom.MEMORY_CARD) {
            output.m_128359_(CONFIG_NBT_TYPE, IPartItem.getId((IPartItem)this.getPartItem()).toString());
            if (this.freq != 0) {
                output.m_128376_(CONFIG_NBT_FREQ, this.freq);
                AEColor[] colors = Platform.p2p().toColors(this.freq);
                int[] colorCode = new int[]{colors[0].ordinal(), colors[0].ordinal(), colors[1].ordinal(), colors[1].ordinal(), colors[2].ordinal(), colors[2].ordinal(), colors[3].ordinal(), colors[3].ordinal()};
                output.m_128385_("colorCode", colorCode);
            }
        }
    }

    public void onTunnelConfigChange() {
    }

    public void onTunnelNetworkChange() {
    }

    protected void queueTunnelDrain(PowerUnits unit, double f) {
        double ae_to_tax = unit.convertTo(PowerUnits.AE, f * 0.05);
        this.getMainNode().ifPresent(grid -> grid.getEnergyService().extractAEPower(ae_to_tax, Actionable.MODULATE, PowerMultiplier.ONE));
    }

    public short getFrequency() {
        return this.freq;
    }

    public void setFrequency(short freq) {
        short oldf = this.freq;
        this.freq = freq;
        if (oldf != this.freq) {
            this.getHost().markForSave();
            this.getHost().markForUpdate();
        }
    }

    public boolean isOutput() {
        return this.output;
    }

    void setOutput(boolean output) {
        this.output = output;
        this.getHost().markForSave();
    }

    public ModelData getModelData() {
        long ret = Short.toUnsignedLong(this.getFrequency());
        if (this.isActive() && this.isPowered()) {
            ret |= 0x10000L;
        }
        return ModelData.builder().with(P2PTunnelFrequencyModelData.FREQUENCY, (Object)ret).build();
    }
}

