/*
 * Decompiled with CFR 0.152.
 */
package stone.mae2.parts.p2p.multi;

import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionSource;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.parts.p2p.P2PModels;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import stone.mae2.MAE2;
import stone.mae2.appeng.helpers.patternprovider.PatternProviderTargetCache;
import stone.mae2.parts.p2p.PatternP2PTunnel;
import stone.mae2.parts.p2p.multi.MultiP2PTunnelPart;

public class PatternMultiP2PPart
extends MultiP2PTunnelPart<PatternMultiP2PPart>
implements PatternP2PTunnel {
    private static final P2PModels MODELS = new P2PModels(MAE2.toKey("part/p2p/multi_p2p_tunnel_pattern"));
    private PatternProviderTargetCache cache;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    public PatternMultiP2PPart(IPartItem<?> partItem) {
        super(partItem);
    }

    public void addToWorld() {
        super.addToWorld();
        Level level = this.getBlockEntity().m_58904_();
        if (!level.f_46443_) {
            this.cache = new PatternProviderTargetCache((ServerLevel)level, this.getBlockEntity().m_58899_().m_121945_(this.getSide()), this.getSide().m_122424_(), (IActionSource)new MachineSource(() -> ((IManagedGridNode)this.getMainNode()).getNode()));
        }
    }

    @Override
    @Nonnull
    public List<PatternP2PTunnel.TunneledPatternProviderTarget> getTargets() {
        if (this.isOutput()) {
            return List.of();
        }
        return this.getOutputStream().map(output -> new PatternP2PTunnel.TunneledPatternProviderTarget(output.getTarget(), new PatternP2PTunnel.TunneledPos(output.getBlockEntity().m_58899_().m_121945_(output.getSide()), output.getSide()))).filter(target -> target.target() != null).toList();
    }

    @Nullable
    private PatternProviderTargetCache getTarget() {
        return this.cache;
    }

    @Override
    @Nullable
    public List<PatternP2PTunnel.TunneledPos> getTunneledPositions() {
        if (this.isOutput()) {
            return List.of();
        }
        ArrayList<PatternP2PTunnel.TunneledPos> outputs = new ArrayList<PatternP2PTunnel.TunneledPos>();
        for (PatternMultiP2PPart output : this.getOutputs()) {
            Direction outputSide = output.getSide();
            outputs.add(new PatternP2PTunnel.TunneledPos(output.getBlockEntity().m_58899_().m_121945_(outputSide), outputSide.m_122424_()));
        }
        return outputs;
    }

    private PatternP2PTunnel.TunneledPos getInputPos() {
        List inputList = this.getInputs();
        if (inputList.isEmpty()) {
            return null;
        }
        PatternMultiP2PPart input = (PatternMultiP2PPart)inputList.get(0);
        Direction inputSide = input.getSide();
        return new PatternP2PTunnel.TunneledPos(input.getBlockEntity().m_58899_().m_121945_(inputSide), inputSide.m_122424_());
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability) {
        if (this.isOutput()) {
            PatternP2PTunnel.TunneledPos provider = this.getInputPos();
            if (provider == null) {
                return LazyOptional.empty();
            }
            BlockEntity providerEntity = this.getLevel().m_7702_(provider.pos());
            if (providerEntity != null) {
                return providerEntity.getCapability(capability, provider.dir());
            }
            return LazyOptional.empty();
        }
        return LazyOptional.empty();
    }
}

