/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.misc;

import appeng.api.stacks.AEItemKey;
import gripe._90.megacells.MEGACells;
import gripe._90.megacells.definition.MEGATags;
import gripe._90.megacells.misc.CompressionChain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class CompressionService {
    public static final CompressionService INSTANCE = new CompressionService();
    private final Set<CompressionChain> compressionChains = new HashSet<CompressionChain>();
    private final Set<Override> overrides = new HashSet<Override>();

    private CompressionService() {
    }

    public Optional<CompressionChain> getChain(AEItemKey item) {
        return this.compressionChains.stream().filter(chain -> chain.containsVariant(item)).findFirst();
    }

    public void loadRecipes(RecipeManager recipeManager, RegistryAccess access) {
        this.compressionChains.clear();
        this.overrides.clear();
        ArrayList<CraftingRecipe> compressed = new ArrayList<CraftingRecipe>();
        ArrayList<CraftingRecipe> decompressed = new ArrayList<CraftingRecipe>();
        for (CraftingRecipe recipe2 : recipeManager.m_44013_(RecipeType.f_44107_)) {
            if (this.isCompressionRecipe(recipe2, access)) {
                compressed.add(recipe2);
                continue;
            }
            if (!this.isDecompressionRecipe(recipe2, access)) continue;
            decompressed.add(recipe2);
        }
        compressed.removeIf(recipe -> this.isIrreversible((CraftingRecipe)recipe, (List<CraftingRecipe>)decompressed, access));
        decompressed.removeIf(recipe -> this.isIrreversible((CraftingRecipe)recipe, (List<CraftingRecipe>)compressed, access));
        Comparator<CraftingRecipe> ingredientSize = Comparator.comparingInt(r -> ((Ingredient)r.m_7527_().get(0)).m_43908_().length);
        compressed.sort(ingredientSize);
        decompressed.sort(ingredientSize);
        Stream.concat(compressed.stream(), decompressed.stream()).forEach(recipe -> {
            Item baseVariant = recipe.m_8043_(access).m_41720_();
            if (this.getChain(AEItemKey.of((ItemLike)baseVariant)).isEmpty()) {
                this.compressionChains.add(this.generateChain(baseVariant, compressed, decompressed, access));
            }
        });
        if (!this.compressionChains.isEmpty()) {
            MEGACells.LOGGER.info("(Re-)initialised bulk cell compression.");
        }
    }

    private CompressionChain generateChain(Item baseVariant, List<CraftingRecipe> compressed, List<CraftingRecipe> decompressed, RegistryAccess access) {
        LinkedList<Item> variants = new LinkedList<Item>();
        LinkedList<Byte> multipliers = new LinkedList<Byte>();
        variants.addFirst(baseVariant);
        Variant lower = this.getNextVariant(baseVariant, decompressed, false, access);
        while (lower != null) {
            variants.addFirst(lower.item().getItem());
            multipliers.addFirst(lower.factor());
            lower = this.getNextVariant(lower.item().getItem(), decompressed, false, access);
        }
        multipliers.addFirst((byte)1);
        CompressionChain chain = new CompressionChain();
        for (int i = 0; i < variants.size(); ++i) {
            chain.add(AEItemKey.of((ItemLike)((ItemLike)variants.get(i))), (Byte)multipliers.get(i));
        }
        Variant higher = this.getNextVariant(baseVariant, compressed, true, access);
        while (higher != null) {
            chain.add(higher);
            higher = this.getNextVariant(higher.item().getItem(), compressed, true, access);
        }
        return chain;
    }

    private Variant getNextVariant(Item item, List<CraftingRecipe> recipes, boolean compressed, RegistryAccess access) {
        for (Override override : this.overrides) {
            if (compressed && override.smaller.equals(item)) {
                return new Variant(override.larger, override.factor);
            }
            if (compressed || !override.larger.equals(item)) continue;
            return new Variant(override.smaller, override.factor);
        }
        for (CraftingRecipe recipe : recipes) {
            for (ItemStack input : ((Ingredient)recipe.m_7527_().get(0)).m_43908_()) {
                if (!input.m_41720_().equals(item)) continue;
                return new Variant(recipe.m_8043_(access).m_41720_(), (byte)(compressed ? recipe.m_7527_().size() : recipe.m_8043_(access).m_41613_()));
            }
        }
        return null;
    }

    private boolean isDecompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        return recipe.m_7527_().stream().filter(i -> !i.m_43947_()).count() == 1L && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(recipe.m_8043_(access).m_41613_());
    }

    private boolean isCompressionRecipe(CraftingRecipe recipe, RegistryAccess access) {
        NonNullList ingredients = recipe.m_7527_();
        return recipe.m_8043_(access).m_41613_() == 1 && ingredients.stream().noneMatch(Ingredient::m_43947_) && Set.of(Integer.valueOf(4), Integer.valueOf(9)).contains(ingredients.size()) && this.sameIngredient(recipe);
    }

    private boolean sameIngredient(CraftingRecipe recipe) {
        NonNullList ingredients = recipe.m_7527_();
        if (recipe instanceof ShapedRecipe && ingredients.stream().distinct().count() <= 1L) {
            return true;
        }
        ItemStack[] first = ((Ingredient)ingredients.get(0)).m_43908_();
        for (Ingredient ingredient : ingredients) {
            ItemStack[] stacks = ingredient.m_43908_();
            if (stacks.length != first.length) {
                return false;
            }
            for (int i = 0; i < stacks.length; ++i) {
                if (ItemStack.m_150942_((ItemStack)stacks[i], (ItemStack)first[i])) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isIrreversible(CraftingRecipe recipe, List<CraftingRecipe> candidates, RegistryAccess access) {
        if (this.overrideRecipe(recipe, access)) {
            return false;
        }
        ItemStack[] testInput = ((Ingredient)recipe.m_7527_().get(0)).m_43908_();
        Item testOutput = recipe.m_8043_(access).m_41720_();
        for (CraftingRecipe candidate : candidates) {
            ItemStack[] input = ((Ingredient)candidate.m_7527_().get(0)).m_43908_();
            Item output = candidate.m_8043_(access).m_41720_();
            boolean compressible = Arrays.stream(input).anyMatch(i -> i.m_150930_(testOutput));
            boolean decompressible = Arrays.stream(testInput).anyMatch(i -> i.m_150930_(output));
            if (!compressible || !decompressible) continue;
            return false;
        }
        return true;
    }

    private boolean overrideRecipe(CraftingRecipe recipe, RegistryAccess access) {
        for (ItemStack input : ((Ingredient)recipe.m_7527_().get(0)).m_43908_()) {
            if (!input.m_204117_(MEGATags.COMPRESSION_OVERRIDES)) continue;
            boolean compressed = !this.isDecompressionRecipe(recipe, access);
            ItemStack output = recipe.m_8043_(access);
            Item smaller = compressed ? input.m_41720_() : output.m_41720_();
            Item larger = compressed ? output.m_41720_() : input.m_41720_();
            byte factor = (byte)(compressed ? recipe.m_7527_().size() : output.m_41613_());
            this.overrides.add(new Override(smaller, larger, factor));
            return true;
        }
        return false;
    }

    public record Variant(AEItemKey item, byte factor) {
        private Variant(Item item, byte factor) {
            this(AEItemKey.of((ItemLike)item), factor);
        }
    }

    private record Override(Item smaller, Item larger, byte factor) {
    }
}

