/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.events;

import com.almostreliable.morejs.core.Events;
import com.almostreliable.morejs.features.villager.VillagerUtils;
import com.almostreliable.morejs.features.villager.events.UpdateVillagerOffersEventJS;
import dev.latvian.mods.kubejs.entity.LivingEntityEventJS;
import dev.latvian.mods.kubejs.event.EventJS;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.WanderingTrader;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;

public class UpdateAbstractVillagerOffersEventJS
extends LivingEntityEventJS {
    private final AbstractVillager villager;
    private final MerchantOffers offers;
    private final VillagerTrades.ItemListing[] currentUsedItemListings;
    private final List<MerchantOffer> addedOffers;
    @Nullable
    private List<VillagerTrades.ItemListing> cachedWandererTrades;

    public static void invokeEvent(AbstractVillager villager, MerchantOffers offers, VillagerTrades.ItemListing[] currentUsedItemListings, List<MerchantOffer> addedOffers) {
        if (villager instanceof Villager) {
            Villager v = (Villager)villager;
            UpdateVillagerOffersEventJS e = new UpdateVillagerOffersEventJS(v, offers, currentUsedItemListings, addedOffers);
            Events.UPDATE_VILLAGER_OFFERS.post((EventJS)e);
            return;
        }
        UpdateAbstractVillagerOffersEventJS e = new UpdateAbstractVillagerOffersEventJS(villager, offers, currentUsedItemListings, addedOffers);
        if (villager instanceof WanderingTrader) {
            Events.UPDATE_WANDERER_OFFERS.post((EventJS)e);
            return;
        }
        Events.UPDATE_ABSTRACT_VILLAGER_OFFERS.post((EventJS)e);
    }

    public UpdateAbstractVillagerOffersEventJS(AbstractVillager villager, MerchantOffers offers, VillagerTrades.ItemListing[] currentUsedItemListings, List<MerchantOffer> addedOffers) {
        this.villager = villager;
        this.offers = offers;
        this.currentUsedItemListings = currentUsedItemListings;
        this.addedOffers = Collections.unmodifiableList(addedOffers);
    }

    public LivingEntity getEntity() {
        return this.villager;
    }

    @Nullable
    public VillagerData getVillagerData() {
        AbstractVillager abstractVillager = this.villager;
        if (abstractVillager instanceof Villager) {
            Villager v = (Villager)abstractVillager;
            return v.m_7141_();
        }
        return null;
    }

    public boolean isVillager() {
        return this.villager instanceof Villager;
    }

    public boolean isWanderer() {
        return this.villager instanceof WanderingTrader;
    }

    public MerchantOffers getOffers() {
        return this.offers;
    }

    public List<VillagerTrades.ItemListing> getUsedTrades() {
        return Arrays.asList(this.currentUsedItemListings);
    }

    public Collection<MerchantOffer> getAddedOffers() {
        return this.addedOffers;
    }

    public void deleteAddedOffers() {
        this.offers.removeAll(this.addedOffers);
    }

    @Nullable
    public MerchantOffer addRandomOffer() {
        return this.addRandomOffer(this.getUsedTrades());
    }

    @Nullable
    public MerchantOffer addRandomOffer(List<VillagerTrades.ItemListing> possibleTrades) {
        if (possibleTrades.isEmpty()) {
            return null;
        }
        int i = this.getLevel().m_213780_().m_188503_(possibleTrades.size());
        VillagerTrades.ItemListing randomListing = possibleTrades.get(i);
        MerchantOffer offer = randomListing.m_213663_((Entity)this.villager, this.getLevel().m_213780_());
        if (offer != null) {
            this.offers.add((Object)offer);
            return offer;
        }
        return null;
    }

    public List<VillagerTrades.ItemListing> getVillagerTrades(VillagerProfession profession) {
        return VillagerUtils.getVillagerTrades(profession);
    }

    public List<VillagerTrades.ItemListing> getVillagerTrades(VillagerProfession profession, int level) {
        return VillagerUtils.getVillagerTrades(profession, level);
    }

    public List<VillagerTrades.ItemListing> getWandererTrades() {
        if (this.cachedWandererTrades == null) {
            this.cachedWandererTrades = new ArrayList<VillagerTrades.ItemListing>();
            for (VillagerTrades.ItemListing[] listings : VillagerTrades.f_35628_.values()) {
                this.cachedWandererTrades.addAll(Arrays.asList(listings));
            }
        }
        return this.cachedWandererTrades;
    }

    public List<VillagerTrades.ItemListing> getWandererTrades(int level) {
        return VillagerUtils.getWandererTrades(level);
    }
}

