/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.redstoneclock.client.screen;

import com.hexagram2021.redstoneclock.client.screen.IButton;
import com.hexagram2021.redstoneclock.common.menu.PulseDividerMenu;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class PulseDividerScreen
extends AbstractContainerScreen<PulseDividerMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("redstoneclock", "textures/gui/pulse_divider.png");
    private static final Component TEXT_SIGNAL_STRENGTH = Component.m_237115_((String)"screen.redstoneclock.pulse_divider.signal_strength");
    private static final Component TEXT_EVERY_PULSE = Component.m_237115_((String)"screen.redstoneclock.pulse_divider.every_pulse");
    private static final PDButton[] BUTTONS = new PDButton[]{new PDButton(7, 24, 16, 16, 0, 88, 0), new PDButton(27, 24, 16, 16, 16, 88, 1), new PDButton(7, 56, 16, 16, 0, 88, 2), new PDButton(27, 56, 16, 16, 16, 88, 3)};

    public PulseDividerScreen(PulseDividerMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 216;
        this.f_97727_ = 88;
    }

    public void m_88315_(GuiGraphics transform, int x, int y, float partialTicks) {
        super.m_88315_(transform, x, y, partialTicks);
        this.m_280072_(transform, x, y);
    }

    protected void m_280003_(GuiGraphics transform, int x, int y) {
        transform.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
        transform.m_280614_(this.f_96547_, TEXT_SIGNAL_STRENGTH, 50, 28, 0x404040, false);
        transform.m_280614_(this.f_96547_, TEXT_EVERY_PULSE, 50, 60, 0x404040, false);
        transform.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.valueOf(((PulseDividerMenu)this.f_97732_).pulseDivider.m_6413_(0))), 168, 28, 0xFFFFFF, false);
        transform.m_280614_(this.f_96547_, (Component)Component.m_237113_((String)String.valueOf(((PulseDividerMenu)this.f_97732_).pulseDivider.m_6413_(1))), 168, 60, 0xFFFFFF, false);
    }

    protected void m_7286_(GuiGraphics transform, float ticks, int x, int y) {
        this.m_280273_(transform);
        transform.m_280218_(BG_LOCATION, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        this.renderButtons(transform, x, y);
    }

    private void renderButtons(GuiGraphics transform, int x, int y) {
        for (PDButton b : BUTTONS) {
            b.render(transform, this.f_97735_, this.f_97736_, x, y);
        }
    }

    public boolean m_6375_(double x, double y, int button) {
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91072_);
        for (PDButton b : BUTTONS) {
            if (!b.click((PulseDividerMenu)this.f_97732_, gameMode, this.f_97735_, this.f_97736_, x, y)) continue;
            return true;
        }
        return super.m_6375_(x, y, button);
    }

    public boolean m_6348_(double x, double y, int button) {
        MultiPlayerGameMode gameMode = Objects.requireNonNull(Objects.requireNonNull(this.f_96541_).f_91072_);
        for (PDButton b : BUTTONS) {
            if (!b.release((PulseDividerMenu)this.f_97732_, gameMode, this.f_97735_, this.f_97736_, x, y)) continue;
            return true;
        }
        return super.m_6348_(x, y, button);
    }

    static class PDButton
    implements IButton<PulseDividerMenu> {
        private final int posX;
        private final int posY;
        private final int width;
        private final int height;
        private final int texX;
        private final int texY;
        private final int index;
        private boolean pressed;

        public PDButton(int posX, int posY, int width, int height, int texX, int texY, int index) {
            this.posX = posX;
            this.posY = posY;
            this.width = width;
            this.height = height;
            this.texX = texX;
            this.texY = texY;
            this.index = index;
            this.pressed = false;
        }

        @Override
        public void render(GuiGraphics transform, int leftPos, int topPos, int x, int y) {
            int buttonTexYAddition = 0;
            int screenX = leftPos + this.posX;
            int screenY = topPos + this.posY;
            if (x >= screenX && x < screenX + this.width && y >= screenY && y < screenY + this.height) {
                buttonTexYAddition = this.pressed ? this.height : this.height * 2;
            }
            transform.m_280218_(BG_LOCATION, screenX, screenY, this.texX, this.texY + buttonTexYAddition, this.width, this.height);
        }

        @Override
        public boolean click(PulseDividerMenu menu, MultiPlayerGameMode gameMode, int leftPos, int topPos, double x, double y) {
            int screenX = leftPos + this.posX;
            int screenY = topPos + this.posY;
            if (x >= (double)screenX && x < (double)(screenX + this.width) && y >= (double)screenY && y < (double)(screenY + this.height)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
                this.pressed = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean release(PulseDividerMenu menu, MultiPlayerGameMode gameMode, int leftPos, int topPos, double x, double y) {
            int screenX = leftPos + this.posX;
            int screenY = topPos + this.posY;
            if (x >= (double)screenX && x < (double)(screenX + this.width) && y >= (double)screenY && y < (double)(screenY + this.height) && this.pressed) {
                this.pressed = false;
                gameMode.m_105208_(menu.f_38840_, this.index);
                return true;
            }
            return false;
        }
    }
}

