/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.redstoneclock.common.block;

import com.hexagram2021.redstoneclock.common.block.entity.RedstoneClockBlockEntity;
import com.hexagram2021.redstoneclock.common.register.RCBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class RedstoneClockBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;

    public RedstoneClockBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public RenderShape m_7514_(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public static boolean hasNeighborSignal(Level level, BlockPos pos, BlockState blockState) {
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        Direction clockWise = facing.m_122427_();
        if (level.m_276987_(pos.m_121945_(clockWise), clockWise)) {
            return true;
        }
        Direction counterClockWise = facing.m_122428_();
        if (level.m_276987_(pos.m_121945_(counterClockWise), counterClockWise)) {
            return true;
        }
        Direction opposite = facing.m_122424_();
        if (level.m_276987_(pos.m_121945_(opposite), opposite)) {
            return true;
        }
        Direction down = Direction.DOWN;
        return level.m_276987_(pos.m_121945_(down), down);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.m_7702_(blockPos);
        if (blockentity instanceof RedstoneClockBlockEntity) {
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockentity;
            player.m_5893_((MenuProvider)redstoneClockBlockEntity);
        }
        return InteractionResult.CONSUME;
    }

    public int m_6378_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof RedstoneClockBlockEntity) {
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
            return (Boolean)blockState.m_61143_((Property)LIT) != false && ((Direction)blockState.m_61143_((Property)FACING)).m_122424_() == direction ? redstoneClockBlockEntity.getSignalStrength() : 0;
        }
        return super.m_6378_(blockState, level, blockPos, direction);
    }

    public int m_6376_(BlockState blockState, BlockGetter level, BlockPos blockPos, Direction direction) {
        return blockState.m_60746_(level, blockPos, direction);
    }

    public boolean m_7899_(BlockState blockState) {
        return true;
    }

    public void m_6861_(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos neighbor, boolean piston) {
        boolean flag = RedstoneClockBlock.hasNeighborSignal(level, blockPos, blockState);
        if ((Boolean)blockState.m_61143_((Property)POWERED) != flag && !level.m_183326_().m_183588_(blockPos, (Object)this)) {
            level.m_7731_(blockPos, (BlockState)((BlockState)blockState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(flag))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState old, boolean piston) {
        for (Direction direction : Direction.values()) {
            level.m_46672_(blockPos.m_121945_(direction), (Block)this);
        }
    }

    public void m_6810_(BlockState blockState, Level level, BlockPos blockPos, BlockState old, boolean piston) {
        for (Direction direction : Direction.values()) {
            level.m_46672_(blockPos.m_121945_(direction), (Block)this);
        }
    }

    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    public void m_6402_(Level level, BlockPos blockPos, BlockState blockState, @Nullable LivingEntity livingEntity, ItemStack itemStack) {
        BlockEntity blockEntity;
        if (itemStack.m_41788_() && (blockEntity = level.m_7702_(blockPos)) instanceof RedstoneClockBlockEntity) {
            RedstoneClockBlockEntity redstoneClockBlockEntity = (RedstoneClockBlockEntity)blockEntity;
            redstoneClockBlockEntity.setCustomName(itemStack.m_41786_());
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED, LIT});
    }

    public RedstoneClockBlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RedstoneClockBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> type) {
        return level.f_46443_ ? null : RedstoneClockBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)RCBlockEntities.REDSTONE_CLOCK.get()), RedstoneClockBlockEntity::serverTick);
    }
}

