/*
 * Decompiled with CFR 0.152.
 */
package com.hexagram2021.redstoneclock.common.block.entity;

import com.hexagram2021.redstoneclock.common.block.RedstoneClockBlock;
import com.hexagram2021.redstoneclock.common.menu.RedstoneClockMenu;
import com.hexagram2021.redstoneclock.common.register.RCBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RedstoneClockBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable {
    public static final int NUM_SLOT = 0;
    public static final int NUM_DATA = 4;
    public static final int BOUND_MULTIPLIER = 5;
    public static final int DATA_SIGNAL_STRENGTH = 0;
    public static final int DATA_ACTIVE_INTERVAL = 1;
    public static final int DATA_IDLE_INTERVAL = 2;
    public static final int DATA_CYCLIC_TICK = 3;
    @Nullable
    private Component name;
    private final Container containerAccess = new Container(){

        public int m_6643_() {
            return 0;
        }

        public boolean m_7983_() {
            return true;
        }

        public ItemStack m_8020_(int index) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int index, int count) {
            return ItemStack.f_41583_;
        }

        public ItemStack m_8016_(int index) {
            return ItemStack.f_41583_;
        }

        public void m_6836_(int index, ItemStack itemStack) {
        }

        public int m_6893_() {
            return 1;
        }

        public void m_6596_() {
            RedstoneClockBlockEntity.this.m_6596_();
        }

        public boolean m_6542_(Player player) {
            return Container.m_272074_((BlockEntity)RedstoneClockBlockEntity.this, (Player)player);
        }

        public boolean m_7013_(int index, ItemStack itemStack) {
            return false;
        }

        public void m_6211_() {
        }
    };
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> RedstoneClockBlockEntity.this.signalStrength;
                case 1 -> RedstoneClockBlockEntity.this.activeInterval;
                case 2 -> RedstoneClockBlockEntity.this.idleInterval;
                case 3 -> RedstoneClockBlockEntity.this.cyclicTick;
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    RedstoneClockBlockEntity.this.signalStrength = value;
                    break;
                }
                case 1: {
                    RedstoneClockBlockEntity.this.activeInterval = value;
                    break;
                }
                case 2: {
                    RedstoneClockBlockEntity.this.idleInterval = value;
                    break;
                }
                case 3: {
                    RedstoneClockBlockEntity.this.cyclicTick = value;
                }
            }
        }

        public int m_6499_() {
            return 4;
        }
    };
    private int signalStrength = 15;
    private int activeInterval = 20;
    private int idleInterval = 20;
    private int multiplier = 0;
    private int cyclicTick = -1;
    private static final String TAG_CUSTOM_NAME = "CustomName";
    private static final String TAG_SIGNAL_STRENGTH = "SignalStrength";
    private static final String TAG_ACTIVE_INTERVAL = "ActiveInterval";
    private static final String TAG_IDLE_INTERVAL = "IdleInterval";
    private static final String TAG_MULTIPLIER = "Multiplier";
    private static final String TAG_CYCLIC_TICK = "CyclicTick";

    public RedstoneClockBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RCBlockEntities.REDSTONE_CLOCK.get(), blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState blockState, RedstoneClockBlockEntity blockEntity) {
        if (((Boolean)blockState.m_61143_((Property)RedstoneClockBlock.POWERED)).booleanValue()) {
            int totalInterval = blockEntity.activeInterval + blockEntity.idleInterval;
            ++blockEntity.cyclicTick;
            if (blockEntity.cyclicTick >= totalInterval) {
                blockEntity.cyclicTick = 0;
            }
            boolean lit = (Boolean)blockState.m_61143_((Property)RedstoneClockBlock.LIT);
            if (blockEntity.cyclicTick < blockEntity.activeInterval) {
                if (!lit) {
                    level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)RedstoneClockBlock.LIT, (Comparable)Boolean.valueOf(true)), 3);
                }
            } else if (lit) {
                level.m_7731_(pos, (BlockState)blockState.m_61124_((Property)RedstoneClockBlock.LIT, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else {
            blockEntity.cyclicTick = -1;
        }
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128425_(TAG_CUSTOM_NAME, 8)) {
            this.name = Component.Serializer.m_130701_((String)nbt.m_128461_(TAG_CUSTOM_NAME));
        }
        this.signalStrength = nbt.m_128451_(TAG_SIGNAL_STRENGTH);
        this.activeInterval = nbt.m_128451_(TAG_ACTIVE_INTERVAL);
        this.idleInterval = nbt.m_128451_(TAG_IDLE_INTERVAL);
        this.multiplier = nbt.m_128451_(TAG_MULTIPLIER);
        this.cyclicTick = nbt.m_128451_(TAG_CYCLIC_TICK);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        if (this.name != null) {
            nbt.m_128359_(TAG_CUSTOM_NAME, Component.Serializer.m_130703_((Component)this.name));
        }
        nbt.m_128405_(TAG_SIGNAL_STRENGTH, this.signalStrength);
        nbt.m_128405_(TAG_ACTIVE_INTERVAL, this.activeInterval);
        nbt.m_128405_(TAG_IDLE_INTERVAL, this.idleInterval);
        nbt.m_128405_(TAG_MULTIPLIER, this.multiplier);
        nbt.m_128405_(TAG_CYCLIC_TICK, this.cyclicTick);
    }

    public void setCustomName(Component name) {
        this.name = name;
    }

    public Component m_7755_() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public Component m_7770_() {
        return this.name;
    }

    protected Component getDefaultName() {
        return Component.m_237115_((String)"block.redstoneclock.redstone_clock");
    }

    public RedstoneClockMenu createMenu(int id, Inventory inventory, Player player) {
        return new RedstoneClockMenu(id, this.containerAccess, this.dataAccess);
    }

    public int getSignalStrength() {
        return this.signalStrength;
    }
}

