/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.entities.hook;

import com.mojang.logging.LogUtils;
import com.oe.rehooked.data.HookData;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.entities.ReHookedEntities;
import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import com.oe.rehooked.item.hook.HookItem;
import com.oe.rehooked.sound.ReHookedSounds;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class HookEntity
extends Projectile {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final EntityDataAccessor<Optional<BlockPos>> HIT_POS = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Integer> STATE = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> PREV_STATE = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Vector3f> DELTA_MOVEMENT = SynchedEntityData.m_135353_(HookEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268676_);
    protected int ticksInState = 0;
    protected boolean firstTickInState = true;
    protected Vec3 offset;

    public HookEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public boolean isPushedByFluid(FluidType type) {
        return false;
    }

    protected boolean m_5603_(Entity pTarget) {
        return false;
    }

    public HookEntity(Player player) {
        super((EntityType)ReHookedEntities.HOOK_PROJECTILE.get(), player.m_9236_());
        this.m_20242_(true);
        this.f_19811_ = true;
        this.m_5602_((Entity)player);
        this.m_146884_(player.m_146892_());
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            return this.m_19749_().m_6000_(pX, pY, pZ) && PositionHelper.getWaistPosition((Entity)owner).m_82554_(this.m_20182_()) > 0.3;
        }
        return false;
    }

    public void m_8119_() {
        Player owner;
        Entity entity;
        if (!(this.getState().equals((Object)State.RETRACTING) || this.m_19749_() instanceof Player || this.m_9236_().m_5776_())) {
            LOGGER.debug("Owner not found, retracting");
            this.setState(State.RETRACTING);
        }
        switch (this.getState()) {
            case SHOT: {
                this.tickShot();
                break;
            }
            case PULLING: {
                this.tickPulling();
                break;
            }
            case RETRACTING: {
                this.tickRetracting();
            }
        }
        Vec3 dV = this.m_20184_();
        if (this.getPrevState().equals((Object)State.SHOT)) {
            this.m_6034_(this.m_20185_() + dV.f_82479_, this.m_20186_() + dV.f_82480_, this.m_20189_() + dV.f_82481_);
        } else if (this.getPrevState().equals((Object)State.RETRACTING)) {
            if (this.m_9236_().m_5776_()) {
                this.m_6034_(this.m_20185_() + dV.f_82479_, this.m_20186_() + dV.f_82480_, this.m_20189_() + dV.f_82481_);
            } else {
                entity = this.m_19749_();
                if (entity instanceof Player) {
                    owner = (Player)entity;
                    this.m_146884_(owner.m_20182_());
                }
            }
        }
        this.trackTicksInState();
        if (this.offset == null && (entity = this.m_19749_()) instanceof Player) {
            owner = (Player)entity;
            this.offset = this.m_20182_().m_82505_(owner.m_20182_().m_82520_(0.0, (double)owner.m_20192_() - 0.1, 0.0)).m_82541_();
        }
        super.m_8119_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void createParticles() {
        this.getHookType().flatMap(HookRegistry::getHookData).map(HookData::particleType).map(Supplier::get).ifPresent(particleType -> {
            Entity patt5348$temp = this.m_19749_();
            if (patt5348$temp instanceof Player) {
                Player owner = (Player)patt5348$temp;
                Vec3 ownerWaist = PositionHelper.getWaistPosition((Entity)owner);
                Vec3 toOwner = this.m_20182_().m_82505_(ownerWaist).m_82541_().m_82490_(0.2);
                for (int i = 1; i < 26; ++i) {
                    this.m_9236_().m_7106_(particleType, Mth.m_14139_((double)((double)i / 50.0), (double)ownerWaist.f_82479_, (double)this.m_20185_()), Mth.m_14139_((double)((double)i / 50.0), (double)ownerWaist.f_82480_, (double)this.m_20186_()), Mth.m_14139_((double)((double)i / 50.0), (double)ownerWaist.f_82481_, (double)this.m_20189_()), toOwner.f_82479_, toOwner.f_82480_, toOwner.f_82481_);
                }
            }
        });
    }

    public void m_20256_(Vec3 pDeltaMovement) {
        this.setSharedDeltaV(pDeltaMovement.m_252839_());
        super.m_20256_(pDeltaMovement);
    }

    public Vec3 m_20184_() {
        return new Vec3(this.getSharedDeltaV());
    }

    public void m_37251_(Entity pShooter, float pX, float pY, float pZ, float pVelocity, float pInaccuracy) {
        LOGGER.debug("Shooting!");
        float f = -Mth.m_14031_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        float f1 = -Mth.m_14031_((float)((pX + pZ) * ((float)Math.PI / 180)));
        float f2 = Mth.m_14089_((float)(pY * ((float)Math.PI / 180))) * Mth.m_14089_((float)(pX * ((float)Math.PI / 180)));
        this.m_6686_(f, f1, f2, pVelocity, pInaccuracy);
        this.m_9236_().m_214150_(null, (double)pX, (double)pY, (double)pZ, (SoundEvent)ReHookedSounds.HOOK_SHOOT.get(), SoundSource.NEUTRAL, 0.2f, 1.0f, 0L);
    }

    protected void tickShot() {
        Optional optHookData = this.getHookType().flatMap(HookRegistry::getHookData);
        if (optHookData.isPresent()) {
            HookData hookData = (HookData)optHookData.get();
            if (!this.m_9236_().m_5776_() && !this.firstTickInState && hookData.speed() == Float.MAX_VALUE) {
                LOGGER.debug("Retracting instant hook on second shot tick");
                this.setState(State.RETRACTING);
                this.m_20256_(Vec3.f_82478_);
                return;
            }
            Entity entity = this.m_19749_();
            if (entity instanceof Player) {
                Player owner = (Player)entity;
                if (this.ticksInState % 10 == 0) {
                    this.m_9236_().m_214150_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), (SoundEvent)ReHookedSounds.HOOK_MOVING.get(), SoundSource.NEUTRAL, 0.2f, 1.0f, 0L);
                }
                if (PositionHelper.getWaistPosition((Entity)owner).m_82554_(this.m_20182_()) > (double)hookData.range()) {
                    LOGGER.debug("Moved further than range from owner");
                    this.setState(State.RETRACTING);
                } else {
                    BlockHitResult hitResult = VectorHelper.getFromEntityAndAngle((Entity)this, this.m_20184_().m_82541_(), this.m_20184_().m_82553_());
                    BlockState hitState = this.m_9236_().m_8055_(hitResult.m_82425_());
                    if (!hitState.m_60795_() && hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                        LOGGER.debug("Hit a block at {}", (Object)hitResult.m_82425_().m_252807_());
                        Vec3 hitLocation = hitResult.m_82450_();
                        this.m_20256_(this.m_20182_().m_82505_(hitLocation));
                        if (!this.m_9236_().m_5776_()) {
                            this.setState(State.PULLING);
                            this.setHitPos(hitResult.m_82425_());
                            this.m_9236_().m_214150_(null, hitLocation.f_82479_, hitLocation.f_82480_, hitLocation.f_82481_, (SoundEvent)ReHookedSounds.HOOK_HIT.get(), SoundSource.NEUTRAL, 0.2f, 0.2f, 0L);
                        }
                    }
                }
            }
        }
    }

    protected void tickPulling() {
        Entity entity;
        if (this.firstTickInState) {
            this.m_20256_(Vec3.f_82478_);
            if (this.m_9236_().m_5776_()) {
                this.getHitPos().map(BlockPos::m_252807_).ifPresent(pos -> {
                    if (this.offset != null) {
                        this.m_146884_(pos.m_82549_(this.offset.m_82490_(0.5)));
                    } else {
                        this.m_146884_((Vec3)pos);
                    }
                });
            }
        }
        this.getHitPos().ifPresent(hitPos -> {
            if (this.m_9236_().m_8055_(hitPos).m_60795_()) {
                this.setState(State.RETRACTING);
            }
        });
        if (this.m_5830_() && (entity = this.m_19749_()) instanceof Player) {
            Player owner = (Player)entity;
            this.m_146884_(this.m_20182_().m_82549_(this.m_20182_().m_82505_(owner.m_20182_()).m_82541_().m_82490_(0.1)));
        }
    }

    protected void tickRetracting() {
        Entity entity = this.m_19749_();
        if (entity instanceof Player) {
            Player owner = (Player)entity;
            if (this.m_9236_().m_5776_()) {
                Vec3 vectorToPlayer = this.m_20182_().m_82505_(owner.m_146892_());
                if (vectorToPlayer.m_82553_() < 5.0) {
                    IClientPlayerHookHandler.FromPlayer(owner).ifPresent(handler -> {
                        handler.removeHook(this);
                        this.m_146870_();
                    });
                } else if (this.ticksInState % 5 == 0) {
                    owner.m_5496_((SoundEvent)ReHookedSounds.HOOK_MOVING.get(), 0.2f, 1.0f);
                }
                this.getHookType().flatMap(HookRegistry::getHookData).ifPresent(hookData -> {
                    float speedModifier;
                    float f = speedModifier = hookData.speed() == Float.MAX_VALUE ? hookData.range() : hookData.speed();
                    if (vectorToPlayer.m_82553_() > (double)(speedModifier / 10.0f)) {
                        this.m_20256_(vectorToPlayer.m_82541_().m_82490_((double)(speedModifier / 10.0f)).m_82549_(owner.m_20184_()));
                    } else {
                        this.m_20256_(vectorToPlayer);
                    }
                });
            }
            if (!this.m_9236_().m_5776_()) {
                if (this.firstTickInState) {
                    this.m_9236_().m_214150_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ReHookedSounds.HOOK_RETRACT.get(), SoundSource.NEUTRAL, 0.2f, 1.0f, 0L);
                    IServerPlayerHookHandler.FromPlayer(owner).ifPresent(handler -> handler.removeHook(this));
                } else if (this.ticksInState > 40) {
                    this.m_146870_();
                }
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    protected void trackTicksInState() {
        State currState = this.getState();
        if (currState.equals((Object)this.getPrevState())) {
            ++this.ticksInState;
            this.firstTickInState = false;
        } else {
            this.firstTickInState = true;
            this.ticksInState = 0;
            LOGGER.debug("Hook changed from {} to {}", (Object)this.getPrevState(), (Object)currState);
            this.setPrevState(currState);
        }
    }

    public boolean hasChain() {
        return this.getHookType().flatMap(HookRegistry::getHookData).map(hookData -> hookData.particleType() == null || !hookData.isCreative()).orElse(false);
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public void setState(State state) {
        this.f_19804_.m_135381_(STATE, (Object)state.ordinal());
    }

    public State getState() {
        return State.values()[(Integer)this.f_19804_.m_135370_(STATE)];
    }

    protected void setHitPos(BlockPos hitPos) {
        this.f_19804_.m_135381_(HIT_POS, Optional.ofNullable(hitPos));
    }

    public Optional<BlockPos> getHitPos() {
        return (Optional)this.f_19804_.m_135370_(HIT_POS);
    }

    public Optional<String> getHookType() {
        return Optional.ofNullable(this.m_19749_()).flatMap(owner -> CurioUtils.GetCuriosOfType(HookItem.class, (LivingEntity)((Player)owner))).flatMap(CurioUtils::GetIfUnique).map(ItemStack::m_41720_).map(item -> (HookItem)((Object)item)).map(HookItem::getHookType);
    }

    protected void setPrevState(State state) {
        this.f_19804_.m_135381_(PREV_STATE, (Object)state.ordinal());
    }

    public State getPrevState() {
        return State.values()[(Integer)this.f_19804_.m_135370_(PREV_STATE)];
    }

    protected void setSharedDeltaV(Vector3f deltaV) {
        this.f_19804_.m_135381_(DELTA_MOVEMENT, (Object)deltaV);
    }

    public Vector3f getSharedDeltaV() {
        return (Vector3f)this.f_19804_.m_135370_(DELTA_MOVEMENT);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(HIT_POS, Optional.empty());
        this.f_19804_.m_135372_(STATE, (Object)State.SHOT.ordinal());
        this.f_19804_.m_135372_(PREV_STATE, (Object)State.SHOT.ordinal());
        this.f_19804_.m_135372_(DELTA_MOVEMENT, (Object)new Vector3f(0.0f, 0.0f, 0.0f));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum State {
        SHOT,
        PULLING,
        RETRACTING;

    }
}

