/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.client;

import com.mojang.logging.LogUtils;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.network.handlers.PacketHandler;
import com.oe.rehooked.network.packets.server.SHookCapabilityPacket;
import com.oe.rehooked.sound.ReHookedSounds;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class CPlayerHookHandler
implements IClientPlayerHookHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<HookEntity> hooks = new ArrayList<HookEntity>();
    private Optional<Player> owner = Optional.empty();
    private Vec3 moveVector = null;
    private long updateCounter;

    @Override
    public void addHook(int id) {
        LOGGER.debug("Adding hook with id: {}", (Object)id);
        if (this.owner.isPresent()) {
            Player player = this.owner.get();
            Entity entity = player.m_9236_().m_6815_(id);
            if (entity instanceof HookEntity) {
                HookEntity hookEntity = (HookEntity)entity;
                LOGGER.debug("Hook entity is being added!");
                this.hooks.add(hookEntity);
                hookEntity.m_5602_((Entity)player);
            }
        } else {
            LOGGER.debug("Owner not found!");
        }
    }

    @Override
    public void addHook(HookEntity hookEntity) {
        this.owner.ifPresentOrElse(owner -> {
            this.hooks.add(hookEntity);
            hookEntity.m_5602_((Entity)owner);
        }, () -> this.hooks.add(hookEntity));
    }

    @Override
    public void removeHook(int id) {
        this.hooks.removeIf(hookEntity -> hookEntity.m_19879_() == id);
    }

    @Override
    public void removeHook(HookEntity hookEntity) {
        PacketHandler.sendToServer(new SHookCapabilityPacket(SHookCapabilityPacket.State.RETRACT_HOOK, hookEntity.m_19879_()));
        this.hooks.remove((Object)hookEntity);
    }

    @Override
    public void removeAllHooks() {
        if (this.hooks.isEmpty()) {
            return;
        }
        LOGGER.debug("Removing all hooks {}", (Object)this.hooks.size());
        this.getOwner().ifPresent(owner -> PacketHandler.sendToServer(new SHookCapabilityPacket(SHookCapabilityPacket.State.RETRACT_ALL_HOOKS)));
        this.hooks.clear();
    }

    @Override
    public void shootFromRotation(float xRot, float yRot) {
        LOGGER.debug("Shooting from rotation: {}, {}", (Object)Float.valueOf(xRot), (Object)Float.valueOf(yRot));
        PacketHandler.sendToServer(new SHookCapabilityPacket(SHookCapabilityPacket.State.SHOOT, 0, xRot, yRot));
    }

    @Override
    public ICommonPlayerHookHandler setOwner(Player owner) {
        this.owner = Optional.of(owner);
        return this;
    }

    @Override
    public Optional<Player> getOwner() {
        return this.owner;
    }

    @Override
    public Collection<HookEntity> getHooks() {
        return this.hooks;
    }

    @Override
    public void update() {
        this.moveVector = null;
        this.getOwner().ifPresent(owner -> {
            this.getHookData().ifPresent(hookData -> {
                if (this.countPulling() == 0) {
                    return;
                }
                owner.m_6853_(false);
                Vec3 ownerWaistPos = PositionHelper.getWaistPosition((Entity)owner);
                float vPT = hookData.pullSpeed() / 20.0f;
                if (hookData.isCreative()) {
                    VectorHelper.Box box = this.getBox();
                    LOGGER.debug("Box {}", (Object)box);
                    if (box.isInside(ownerWaistPos)) {
                        owner.m_6853_(true);
                        return;
                    }
                    this.moveVector = ownerWaistPos.m_82505_(box.closestPointInCube(ownerWaistPos));
                } else {
                    owner.m_20242_(true);
                    Vec3 pullCenter = this.getPullCenter();
                    double x = pullCenter.f_82479_ - ownerWaistPos.f_82479_;
                    double y = pullCenter.f_82480_ - ownerWaistPos.f_82480_;
                    double z = pullCenter.f_82481_ - ownerWaistPos.f_82481_;
                    this.moveVector = new Vec3(x, y, z);
                }
                this.moveVector = this.reduceCollisions(this.moveVector);
                if (this.moveVector.m_82553_() > (double)vPT) {
                    this.moveVector = this.moveVector.m_82541_().m_82490_((double)vPT);
                }
                if (!hookData.isCreative() && this.moveVector.m_82553_() < 0.2) {
                    this.moveVector = Vec3.f_82478_;
                }
            });
            owner.m_6885_();
        });
        this.handleParticles();
        if (this.updateCounter % 10L == 0L && this.moveVector != null && this.moveVector.m_82553_() > 0.5) {
            this.getOwner().ifPresent(owner -> owner.m_5496_((SoundEvent)ReHookedSounds.HOOK_MOVING.get(), 0.2f, 1.0f));
        }
        ++this.updateCounter;
    }

    @Override
    public boolean shouldMoveThisTick() {
        return this.moveVector != null;
    }

    @Override
    public Vec3 getDeltaVThisTick() {
        return this.moveVector;
    }

    @Override
    public double getMaxHookDistance() {
        if (this.hooks.isEmpty() || this.getOwner().isEmpty()) {
            return 0.0;
        }
        Player owner = this.getOwner().get();
        Vec3 adjustedOwnerPosition = PositionHelper.getWaistPosition((Entity)owner);
        double maxDistance = 0.0;
        for (HookEntity hookEntity : this.hooks) {
            double distance = hookEntity.m_20182_().m_82554_(adjustedOwnerPosition);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        return maxDistance + 0.2;
    }

    @Override
    public void handleParticles() {
        for (HookEntity hookEntity : this.getHooks()) {
            hookEntity.createParticles();
        }
    }
}

