/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.def;

import com.oe.rehooked.data.HookData;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.item.hook.HookItem;
import com.oe.rehooked.utils.CurioUtils;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public interface ICommonPlayerHookHandler {
    public static final double THRESHOLD = 0.2;

    public void addHook(int var1);

    public void addHook(HookEntity var1);

    public void removeHook(int var1);

    public void removeHook(HookEntity var1);

    public void removeAllHooks();

    public void shootFromRotation(float var1, float var2);

    public ICommonPlayerHookHandler setOwner(Player var1);

    public Optional<Player> getOwner();

    default public Optional<HookData> getHookData() {
        return this.getOwner().flatMap(owner -> CurioUtils.GetCuriosOfType(HookItem.class, (LivingEntity)owner)).flatMap(CurioUtils::GetIfUnique).map(ItemStack::m_41720_).map(item -> ((HookItem)((Object)item)).getHookType()).flatMap(HookRegistry::getHookData);
    }

    public void update();

    public boolean shouldMoveThisTick();

    public Vec3 getDeltaVThisTick();

    default public int countPulling() {
        int count = 0;
        for (HookEntity hookEntity : this.getHooks()) {
            if (!hookEntity.getState().equals((Object)HookEntity.State.PULLING)) continue;
            ++count;
        }
        return count;
    }

    public Collection<HookEntity> getHooks();

    default public Vec3 getPullCenter() {
        double pulling = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (HookEntity hookEntity : this.getHooks()) {
            if (!hookEntity.getState().equals((Object)HookEntity.State.PULLING) || !hookEntity.getHitPos().isPresent()) continue;
            pulling += 1.0;
            Vec3 hit = hookEntity.getHitPos().get().m_252807_();
            x += hit.f_82479_;
            y += hit.f_82480_;
            z += hit.f_82481_;
        }
        return new Vec3(x / pulling, y / pulling, z / pulling);
    }

    default public VectorHelper.Box getBox() {
        VectorHelper.Box box = new VectorHelper.Box();
        for (HookEntity hookEntity : this.getHooks()) {
            box.reassignPoints(hookEntity.m_20182_());
        }
        return box;
    }

    default public Vec3 reduceCollisions(Vec3 moveVector) {
        return this.reduceCollisions(moveVector.f_82479_, moveVector.f_82480_, moveVector.f_82481_);
    }

    default public Vec3 reduceCollisions(double dX, double dY, double dZ) {
        return this.getOwner().map(owner -> {
            double x = dX;
            double y = dY;
            double z = dZ;
            Vec3 ownerWaistPosition = PositionHelper.getWaistPosition((Entity)owner);
            BlockHitResult hitResult = VectorHelper.getFromEntityAndAngle((Entity)owner, new Vec3(1.0, 0.0, 0.0), x, PositionHelper::getWaistPosition);
            if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK) && !owner.m_9236_().m_8055_(hitResult.m_82425_()).m_60795_() && Math.abs(x = hitResult.m_82450_().m_82554_(ownerWaistPosition) * Math.signum(x)) <= 1.0) {
                x = 0.0;
            }
            if ((hitResult = VectorHelper.getFromEntityAndAngle((Entity)owner, new Vec3(0.0, 1.0, 0.0), y, PositionHelper::getWaistPosition)).m_6662_().equals((Object)HitResult.Type.BLOCK) && !owner.m_9236_().m_8055_(hitResult.m_82425_()).m_60795_() && Math.abs(y = hitResult.m_82450_().m_82554_(ownerWaistPosition) * Math.signum(y)) <= 1.5) {
                y = 0.0;
            }
            if ((hitResult = VectorHelper.getFromEntityAndAngle((Entity)owner, new Vec3(0.0, 0.0, 1.0), z, PositionHelper::getWaistPosition)).m_6662_().equals((Object)HitResult.Type.BLOCK) && !owner.m_9236_().m_8055_(hitResult.m_82425_()).m_60795_() && Math.abs(z = hitResult.m_82450_().m_82554_(ownerWaistPosition) * Math.signum(z)) <= 1.0) {
                z = 0.0;
            }
            return new Vec3(x, y, z);
        }).orElse(null);
    }

    default public void onUnequip() {
        this.removeAllHooks();
        this.update();
    }

    default public void onEquip() {
        this.removeAllHooks();
        this.update();
    }
}

