/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.server;

import com.mojang.logging.LogUtils;
import com.oe.rehooked.entities.hook.HookEntity;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import com.oe.rehooked.network.handlers.PacketHandler;
import com.oe.rehooked.network.packets.client.CHookCapabilityPacket;
import com.oe.rehooked.utils.PositionHelper;
import com.oe.rehooked.utils.VectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;

public class SPlayerHookHandler
implements IServerPlayerHookHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<HookEntity> hooks = new ArrayList<HookEntity>();
    private Optional<Player> owner = Optional.empty();
    private Vec3 moveVector = null;
    private boolean hookFlightActive = false;
    private boolean externalFlight = false;

    @Override
    public void addHook(int id) {
        LOGGER.debug("Adding new hook by id: {}", (Object)id);
        this.getOwner().map(Entity::m_9236_).map(level -> level.m_6815_(id)).map(entity -> {
            if (entity instanceof HookEntity) {
                HookEntity hookEntity = (HookEntity)((Object)entity);
                this.hooks.add(hookEntity);
                return hookEntity;
            }
            return null;
        }).flatMap(hookEntity -> this.getOwner()).ifPresent(owner -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.ADD_HOOK, id), (ServerPlayer)owner));
    }

    @Override
    public void addHook(HookEntity hookEntity) {
        LOGGER.debug("Adding new hook by entity with id: {}", (Object)hookEntity.m_19879_());
        this.hooks.add(hookEntity);
        this.getOwner().ifPresent(owner -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.ADD_HOOK, hookEntity.m_19879_()), (ServerPlayer)owner));
    }

    @Override
    public void removeHook(int id) {
        LOGGER.debug("Removing hook by id: {}", (Object)id);
        if (this.hooks.removeIf(hookEntity -> hookEntity.m_19879_() == id)) {
            this.getOwner().map(Entity::m_9236_).map(level -> level.m_6815_(id)).ifPresent(entity -> {
                if (entity instanceof HookEntity) {
                    HookEntity hookEntity = (HookEntity)((Object)entity);
                    hookEntity.setState(HookEntity.State.RETRACTING);
                }
            });
        }
    }

    @Override
    public void removeHook(HookEntity hookEntity) {
        LOGGER.debug("Removing hook by entity with id: {}", (Object)hookEntity.m_19879_());
        if (this.hooks.remove((Object)hookEntity)) {
            hookEntity.setState(HookEntity.State.RETRACTING);
            this.getOwner().ifPresent(owner -> PacketHandler.sendToPlayer(new CHookCapabilityPacket(CHookCapabilityPacket.State.RETRACT_HOOK, hookEntity.m_19879_()), (ServerPlayer)owner));
        }
    }

    @Override
    public void removeAllHooks() {
        LOGGER.debug("Removing all hooks ({})", (Object)this.hooks.size());
        this.hooks.forEach(hookEntity -> hookEntity.setState(HookEntity.State.RETRACTING));
        this.hooks.clear();
    }

    @Override
    public void shootFromRotation(float xRot, float yRot) {
        LOGGER.debug("Shooting from rotation: {}, {}", (Object)Float.valueOf(xRot), (Object)Float.valueOf(yRot));
        this.getOwner().ifPresent(owner -> this.getHookData().ifPresent(hookData -> {
            if (this.hooks.size() + 1 > hookData.count()) {
                this.removeHook(this.hooks.get(0));
            }
            HookEntity hookEntity = new HookEntity((Player)owner);
            owner.m_9236_().m_7967_((Entity)hookEntity);
            this.addHook(hookEntity);
            hookEntity.m_37251_((Entity)owner, xRot, yRot, 0.0f, hookData.speed() == Float.MAX_VALUE ? hookData.range() : hookData.speed() / 20.0f, 0.0f);
        }));
    }

    @Override
    public ICommonPlayerHookHandler setOwner(Player owner) {
        this.owner = Optional.of(owner);
        return this;
    }

    @Override
    public Optional<Player> getOwner() {
        return this.owner;
    }

    private void updateCreativeFlight() {
        this.getOwner().ifPresent(owner -> this.getHookData().ifPresent(hookData -> {
            if (!this.hookFlightActive) {
                this.externalFlight = owner.m_150110_().f_35936_ || owner.m_150110_().f_35935_;
            } else if (!owner.m_150110_().f_35936_ && !owner.m_150110_().f_35935_) {
                this.externalFlight = false;
            }
            if (owner.m_7500_()) {
                this.externalFlight = true;
            }
            Vec3 ownerWaistPos = PositionHelper.getWaistPosition((Entity)owner);
            VectorHelper.Box box = this.getBox();
            this.hookFlightActive = hookData.isCreative() && this.countPulling() > 0 && (box.isInside(ownerWaistPos) || box.closestPointInCube(ownerWaistPos).m_82554_(ownerWaistPos) < 5.0);
            boolean old = owner.m_150110_().f_35936_;
            boolean bl = owner.m_150110_().f_35936_ = this.externalFlight || this.hookFlightActive;
            if (!this.externalFlight && !this.hookFlightActive) {
                owner.m_150110_().f_35935_ = false;
            }
            if (old != owner.m_150110_().f_35936_) {
                owner.m_6885_();
            }
        }));
    }

    @Override
    public void update() {
        this.moveVector = null;
        this.updateCreativeFlight();
        this.getOwner().ifPresent(owner -> {
            owner.m_20242_(false);
            this.getHookData().ifPresent(hookData -> {
                if (this.countPulling() == 0) {
                    return;
                }
                owner.m_183634_();
                owner.m_6853_(false);
                float vPT = hookData.pullSpeed() / 20.0f;
                Vec3 ownerWaistPos = PositionHelper.getWaistPosition((Entity)owner);
                if (!hookData.isCreative()) {
                    owner.m_20242_(true);
                    Vec3 pullCenter = this.getPullCenter();
                    double x = pullCenter.f_82479_ - ownerWaistPos.f_82479_;
                    double y = pullCenter.f_82480_ - ownerWaistPos.f_82480_;
                    double z = pullCenter.f_82481_ - ownerWaistPos.f_82481_;
                    this.moveVector = new Vec3(x, y, z);
                } else {
                    VectorHelper.Box box = this.getBox();
                    LOGGER.debug("Box {}", (Object)box);
                    if (!box.isInside(ownerWaistPos)) {
                        this.moveVector = ownerWaistPos.m_82505_(box.closestPointInCube(ownerWaistPos));
                    } else {
                        owner.m_6853_(true);
                        return;
                    }
                }
                this.moveVector = this.reduceCollisions(this.moveVector);
                if (this.moveVector.m_82553_() > (double)vPT) {
                    this.moveVector = this.moveVector.m_82541_().m_82490_((double)vPT);
                }
                if (this.moveVector.m_82553_() < 0.2) {
                    this.moveVector = Vec3.f_82478_;
                }
            });
            owner.m_6885_();
        });
    }

    @Override
    public boolean shouldMoveThisTick() {
        return this.moveVector != null;
    }

    @Override
    public Vec3 getDeltaVThisTick() {
        return this.moveVector;
    }

    @Override
    public Collection<HookEntity> getHooks() {
        return this.hooks;
    }
}

