/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.handlers.hook.server;

import com.oe.rehooked.data.HookData;
import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import net.minecraft.server.level.ServerPlayer;

public class FlightHandler {
    private boolean prevMayFly = false;
    private boolean externalFlight = false;
    private boolean clientFlightEnabled = false;
    private boolean serverFlightEnabled = false;

    public void updateFlight(ServerPlayer owner, IServerPlayerHookHandler handler) {
        boolean externalFlightChanged = this.externalFlightChanged(owner);
        boolean shouldEnableServerFlight = this.shouldEnableServerFlight(owner, handler);
        boolean shouldEnableClientFlight = this.shouldEnableClientFlight(owner, handler);
        this.setFlightState(owner, shouldEnableServerFlight, shouldEnableClientFlight, externalFlightChanged);
        this.prevMayFly = owner.m_150110_().f_35936_;
    }

    private boolean shouldEnableClientFlight(ServerPlayer owner, IServerPlayerHookHandler handler) {
        return this.externalFlight || handler.getHookData().map(HookData::isCreative).orElse(false) != false && handler.countPulling() >= 2;
    }

    private boolean shouldEnableServerFlight(ServerPlayer owner, IServerPlayerHookHandler handler) {
        return this.externalFlight || handler.countPulling() > 0;
    }

    private void setFlightState(ServerPlayer owner, boolean shouldEnableServerFlight, boolean shouldEnableClientFlight, boolean externalFlightChanged) {
        if (this.clientFlightEnabled != shouldEnableClientFlight || externalFlightChanged) {
            owner.m_150110_().f_35936_ = owner.m_150110_().f_35935_ = shouldEnableClientFlight;
            if (!externalFlightChanged || this.externalFlight != shouldEnableClientFlight) {
                owner.m_6885_();
            }
            this.clientFlightEnabled = shouldEnableClientFlight;
        }
        if (this.serverFlightEnabled != shouldEnableServerFlight || externalFlightChanged) {
            owner.m_150110_().f_35936_ = owner.m_150110_().f_35935_ = shouldEnableServerFlight;
            this.serverFlightEnabled = shouldEnableServerFlight;
        }
    }

    private boolean externalFlightChanged(ServerPlayer owner) {
        boolean changed;
        boolean bl = changed = this.serverFlightEnabled != owner.m_150110_().f_35936_ && this.prevMayFly != owner.m_150110_().f_35936_;
        if (changed) {
            this.externalFlight = owner.m_150110_().f_35936_;
        }
        return changed;
    }
}

