/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.item;

import com.oe.rehooked.config.client.visuals.HookVisualsConfig;
import com.oe.rehooked.config.server.stats.HookStatsConfig;
import com.oe.rehooked.data.AdditionalHandlersRegistry;
import com.oe.rehooked.data.HookData;
import com.oe.rehooked.data.HookRegistry;
import com.oe.rehooked.handlers.additional.FireHookHandler;
import com.oe.rehooked.item.hook.HookItem;
import com.oe.rehooked.particle.ReHookedParticles;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ReHookedItems {
    public static final String WOOD = "wood";
    public static final String IRON = "iron";
    public static final String DIAMOND = "diamond";
    public static final String RED = "red";
    public static final String ENDER = "ender";
    public static final String BLAZE = "blaze";
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"rehooked");
    public static final RegistryObject<Item> WOOD_HOOK = ReHookedItems.CreateHookItem("wood");
    public static final RegistryObject<Item> IRON_HOOK = ReHookedItems.CreateHookItem("iron");
    public static final RegistryObject<Item> DIAMOND_HOOK = ReHookedItems.CreateHookItem("diamond");
    public static final RegistryObject<Item> RED_HOOK = ReHookedItems.CreateHookItem("red");
    public static final RegistryObject<Item> BLAZE_HOOK = ReHookedItems.CreateHookItem("blaze");
    public static final RegistryObject<Item> ENDER_HOOK = ReHookedItems.CreateHookItem("ender");

    private static RegistryObject<Item> CreateHookItem(String type) {
        return ITEMS.register(type + "_hook", () -> new HookItem(type));
    }

    public static void Init(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    private static HookData CompleteConfigData(String type, Supplier<ParticleOptions> particleType, int minParticlesPerBlock, int maxParticlesPerBlock, double radius, int ticksBetweenSpawns) {
        return HookStatsConfig.GetConfigDataForType(type).map(HookStatsConfig.HookConfigData::getData).map(partial -> partial.complete(type, ReHookedItems.getHookTexture(type), particleType, minParticlesPerBlock, maxParticlesPerBlock, radius, ticksBetweenSpawns)).orElse(null);
    }

    private static HookData CompleteConfigData(String type) {
        return HookStatsConfig.GetConfigDataForType(type).map(HookStatsConfig.HookConfigData::getData).map(partial -> partial.complete(type, ReHookedItems.getHookTexture(type), () -> null, 0, 0, 0.0, 0)).orElse(null);
    }

    private static ResourceLocation getHookTexture(String name) {
        return new ResourceLocation("rehooked", "textures/entity/hook/" + name + "/" + name + ".png");
    }

    private static void RegisterHookWithParticles(String type, Supplier<ParticleOptions> particleType, int minParticlesPerBlock, int maxParticlesPerBlock, double radius, int ticksBetweenSpawns) {
        HookRegistry.registerHook(type, ReHookedItems.CompleteConfigData(type, particleType, minParticlesPerBlock, maxParticlesPerBlock, radius, ticksBetweenSpawns));
    }

    private static void RegisterHookWithChain(String type) {
        HookRegistry.registerHook(type, ReHookedItems.CompleteConfigData(type));
    }

    public static void RegisterConfigProperties() {
        ReHookedItems.RegisterHookWithChain(WOOD);
        ReHookedItems.RegisterHookWithChain(IRON);
        ReHookedItems.RegisterHookWithChain(DIAMOND);
        if (HookVisualsConfig.getChainSetting(ENDER).map(value -> ((String)value.get()).equals("chain")).orElse(false).booleanValue()) {
            ReHookedItems.RegisterHookWithChain(ENDER);
        } else {
            ReHookedItems.RegisterHookWithParticles(ENDER, () -> ReHookedParticles.ENDER_HOOK_PARTICLE.get(), 1, 2, 0.2, 4);
        }
        ReHookedItems.RegisterHookWithParticles(RED, () -> ReHookedParticles.RED_HOOK_PARTICLE.get(), 1, 2, 0.1, 4);
        if (HookVisualsConfig.getChainSetting(BLAZE).map(value -> ((String)value.get()).equals("chain")).orElse(false).booleanValue()) {
            ReHookedItems.RegisterHookWithChain(BLAZE);
        } else {
            ReHookedItems.RegisterHookWithParticles(BLAZE, () -> ((SimpleParticleType)ParticleTypes.f_123744_).m_6012_(), 0, 1, 0.1, 20);
        }
        AdditionalHandlersRegistry.registerHandler(BLAZE, FireHookHandler.class);
    }
}

