/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.network.packets.server;

import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class SHookCapabilityPacket {
    private final State packetType;
    private final int id;
    private final float xRot;
    private final float yRot;

    public SHookCapabilityPacket(State packetType, int id, float xRot, float yRot) {
        this.packetType = packetType;
        this.id = id;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public SHookCapabilityPacket(State packetType, int id) {
        this(packetType, id, 0.0f, 0.0f);
    }

    public SHookCapabilityPacket(State packetType) {
        this(packetType, 0);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.packetType.ordinal());
        buf.writeInt(this.id);
        buf.writeFloat(this.xRot);
        buf.writeFloat(this.yRot);
    }

    public SHookCapabilityPacket(FriendlyByteBuf buf) {
        this.packetType = State.Get(buf.readInt());
        this.id = buf.readInt();
        this.xRot = buf.readFloat();
        this.yRot = buf.readFloat();
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            Optional optHandler = IServerPlayerHookHandler.FromPlayer((Player)player).resolve();
            if (optHandler.isPresent()) {
                IServerPlayerHookHandler handler = (IServerPlayerHookHandler)optHandler.get();
                handler.setOwner((Player)player);
                switch (this.packetType) {
                    case SHOOT: {
                        handler.shootFromRotation(this.xRot, this.yRot);
                        break;
                    }
                    case RETRACT_HOOK: {
                        handler.removeHook(this.id);
                        break;
                    }
                    case RETRACT_ALL_HOOKS: {
                        handler.removeAllHooks();
                        break;
                    }
                    case FORCE_UPDATE: {
                        handler.update();
                        break;
                    }
                    case JUMP: {
                        handler.jump();
                        break;
                    }
                    case KILL: {
                        handler.killHook(this.id);
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static enum State {
        SHOOT,
        RETRACT_HOOK,
        RETRACT_ALL_HOOKS,
        JUMP,
        FORCE_UPDATE,
        KILL;


        public static State Get(int ordinal) {
            return State.values()[ordinal];
        }
    }
}

