/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.ForgeRegistries;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.item.WoodStorageBlockItem;

public abstract class WoodStorageBlockEntity
extends StorageBlockEntity {
    private static final String PACKED_TAG = "packed";
    @Nullable
    private WoodType woodType = null;
    private boolean packed = false;

    protected WoodStorageBlockEntity(BlockPos pos, BlockState state, BlockEntityType<? extends StorageBlockEntity> blockEntityType) {
        super(pos, state, blockEntityType);
    }

    @Override
    protected void saveSynchronizedData(CompoundTag tag) {
        super.saveSynchronizedData(tag);
        if (this.woodType != null) {
            tag.m_128359_("woodType", this.woodType.f_61839_());
        }
        tag.m_128379_(PACKED_TAG, this.packed);
    }

    public CompoundTag getStorageContentsTag() {
        CompoundTag contents = this.m_187482_();
        contents.m_128379_(PACKED_TAG, false);
        return contents;
    }

    @Override
    public void loadSynchronizedData(CompoundTag tag) {
        super.loadSynchronizedData(tag);
        this.woodType = NBTHelper.getString((CompoundTag)tag, (String)"woodType").flatMap(woodTypeName -> WoodType.m_61843_().filter(wt -> wt.f_61839_().equals(woodTypeName)).findFirst()).orElse(this.getStorageWrapper().hasMainColor() && this.getStorageWrapper().hasAccentColor() ? null : WoodType.f_61833_);
        this.packed = tag.m_128471_(PACKED_TAG);
    }

    public Optional<WoodType> getWoodType() {
        return Optional.ofNullable(this.woodType);
    }

    public void setWoodType(WoodType woodType) {
        this.woodType = woodType;
        this.m_6596_();
    }

    @Override
    public Component m_5446_() {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.makeWoodStorageDescriptionId(this.getWoodType().orElse(null));
    }

    private Component makeWoodStorageDescriptionId(@Nullable WoodType wt) {
        String id = Util.m_137492_((String)"block", (ResourceLocation)Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)this.m_58900_().m_60734_())));
        return WoodStorageBlockItem.getDisplayName(id, wt);
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void setPacked(boolean packed) {
        this.packed = packed;
    }

    @Override
    public boolean shouldDropContents() {
        return !this.isPacked();
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (this.isPacked() && cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canConnectStorages() {
        return !this.packed && super.canConnectStorages();
    }

    @Override
    public boolean canBeConnected() {
        return !this.packed && super.canBeConnected();
    }

    public boolean canBeLinked() {
        return !this.packed;
    }
}

